/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.media.VolumeProvider;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class VolumeProviderCompat {
    public static final int VOLUME_CONTROL_FIXED = 0;
    public static final int VOLUME_CONTROL_RELATIVE = 1;
    public static final int VOLUME_CONTROL_ABSOLUTE = 2;
    private final int mControlType;
    private final int mMaxVolume;
    private final String mControlId;
    private int mCurrentVolume;
    private Callback mCallback;
    private VolumeProvider mVolumeProviderFwk;

    public VolumeProviderCompat(int volumeControl, int maxVolume, int currentVolume) {
        this(volumeControl, maxVolume, currentVolume, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public VolumeProviderCompat(int volumeControl, int maxVolume, int currentVolume, @Nullable String volumeControlId) {
        this.mControlType = volumeControl;
        this.mMaxVolume = maxVolume;
        this.mCurrentVolume = currentVolume;
        this.mControlId = volumeControlId;
    }

    public final int getCurrentVolume() {
        return this.mCurrentVolume;
    }

    public final int getVolumeControl() {
        return this.mControlType;
    }

    public final int getMaxVolume() {
        return this.mMaxVolume;
    }

    public final void setCurrentVolume(int currentVolume) {
        this.mCurrentVolume = currentVolume;
        if (Build.VERSION.SDK_INT >= 21) {
            VolumeProvider volumeProviderFwk = (VolumeProvider)this.getVolumeProvider();
            Api21Impl.setCurrentVolume(volumeProviderFwk, currentVolume);
        }
        if (this.mCallback != null) {
            this.mCallback.onVolumeChanged(this);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public final String getVolumeControlId() {
        return this.mControlId;
    }

    public void onSetVolumeTo(int volume) {
    }

    public void onAdjustVolume(int direction) {
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public Object getVolumeProvider() {
        if (this.mVolumeProviderFwk == null) {
            if (Build.VERSION.SDK_INT >= 30) {
                this.mVolumeProviderFwk = new VolumeProvider(this.mControlType, this.mMaxVolume, this.mCurrentVolume, this.mControlId){

                    public void onSetVolumeTo(int volume) {
                        VolumeProviderCompat.this.onSetVolumeTo(volume);
                    }

                    public void onAdjustVolume(int direction) {
                        VolumeProviderCompat.this.onAdjustVolume(direction);
                    }
                };
            } else if (Build.VERSION.SDK_INT >= 21) {
                this.mVolumeProviderFwk = new VolumeProvider(this.mControlType, this.mMaxVolume, this.mCurrentVolume){

                    public void onSetVolumeTo(int volume) {
                        VolumeProviderCompat.this.onSetVolumeTo(volume);
                    }

                    public void onAdjustVolume(int direction) {
                        VolumeProviderCompat.this.onAdjustVolume(direction);
                    }
                };
            }
        }
        return this.mVolumeProviderFwk;
    }

    @RequiresApi(value=21)
    private static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static void setCurrentVolume(VolumeProvider volumeProvider, int currentVolume) {
            volumeProvider.setCurrentVolume(currentVolume);
        }
    }

    public static abstract class Callback {
        public abstract void onVolumeChanged(VolumeProviderCompat var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface ControlType {
    }
}

