/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.ObjectsCompat;
import androidx.media.MediaSessionManager;

class MediaSessionManagerImplBase
implements MediaSessionManager.MediaSessionManagerImpl {
    private static final String TAG = "MediaSessionManager";
    private static final boolean DEBUG = MediaSessionManager.DEBUG;
    private static final String PERMISSION_STATUS_BAR_SERVICE = "android.permission.STATUS_BAR_SERVICE";
    private static final String PERMISSION_MEDIA_CONTENT_CONTROL = "android.permission.MEDIA_CONTENT_CONTROL";
    private static final String ENABLED_NOTIFICATION_LISTENERS = "enabled_notification_listeners";
    Context mContext;
    ContentResolver mContentResolver;

    MediaSessionManagerImplBase(Context context) {
        this.mContext = context;
        this.mContentResolver = this.mContext.getContentResolver();
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public boolean isTrustedForMediaControl(@NonNull MediaSessionManager.RemoteUserInfoImpl userInfo) {
        try {
            ApplicationInfo applicationInfo = this.mContext.getPackageManager().getApplicationInfo(userInfo.getPackageName(), 0);
            if (applicationInfo == null) {
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            if (DEBUG) {
                Log.d((String)TAG, (String)("Package " + userInfo.getPackageName() + " doesn't exist"));
            }
            return false;
        }
        return this.isPermissionGranted(userInfo, PERMISSION_STATUS_BAR_SERVICE) || this.isPermissionGranted(userInfo, PERMISSION_MEDIA_CONTENT_CONTROL) || userInfo.getUid() == 1000 || this.isEnabledNotificationListener(userInfo);
    }

    private boolean isPermissionGranted(MediaSessionManager.RemoteUserInfoImpl userInfo, String permission2) {
        if (userInfo.getPid() < 0) {
            return this.mContext.getPackageManager().checkPermission(permission2, userInfo.getPackageName()) == 0;
        }
        return this.mContext.checkPermission(permission2, userInfo.getPid(), userInfo.getUid()) == 0;
    }

    boolean isEnabledNotificationListener(@NonNull MediaSessionManager.RemoteUserInfoImpl userInfo) {
        String enabledNotifListeners = Settings.Secure.getString((ContentResolver)this.mContentResolver, (String)ENABLED_NOTIFICATION_LISTENERS);
        if (enabledNotifListeners != null) {
            String[] components = enabledNotifListeners.split(":");
            for (int i = 0; i < components.length; ++i) {
                ComponentName component = ComponentName.unflattenFromString((String)components[i]);
                if (component == null || !component.getPackageName().equals(userInfo.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    static class RemoteUserInfoImplBase
    implements MediaSessionManager.RemoteUserInfoImpl {
        private String mPackageName;
        private int mPid;
        private int mUid;

        RemoteUserInfoImplBase(String packageName, int pid, int uid) {
            this.mPackageName = packageName;
            this.mPid = pid;
            this.mUid = uid;
        }

        @Override
        public String getPackageName() {
            return this.mPackageName;
        }

        @Override
        public int getPid() {
            return this.mPid;
        }

        @Override
        public int getUid() {
            return this.mUid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RemoteUserInfoImplBase)) {
                return false;
            }
            RemoteUserInfoImplBase otherUserInfo = (RemoteUserInfoImplBase)obj;
            if (this.mPid < 0 || otherUserInfo.mPid < 0) {
                return TextUtils.equals((CharSequence)this.mPackageName, (CharSequence)otherUserInfo.mPackageName) && this.mUid == otherUserInfo.mUid;
            }
            return TextUtils.equals((CharSequence)this.mPackageName, (CharSequence)otherUserInfo.mPackageName) && this.mPid == otherUserInfo.mPid && this.mUid == otherUserInfo.mUid;
        }

        public int hashCode() {
            return ObjectsCompat.hash((Object[])new Object[]{this.mPackageName, this.mUid});
        }
    }
}

