/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.window.extensions.layout.WindowLayoutComponent;
import androidx.window.layout.EmptyDecorator;
import androidx.window.layout.ExtensionWindowLayoutInfoBackend;
import androidx.window.layout.SafeWindowLayoutComponentProvider;
import androidx.window.layout.SidecarWindowBackend;
import androidx.window.layout.WindowBackend;
import androidx.window.layout.WindowInfoTrackerDecorator;
import androidx.window.layout.WindowInfoTrackerImpl;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.layout.WindowMetricsCalculatorCompat;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\b"}, d2={"Landroidx/window/layout/WindowInfoTracker;", "", "windowLayoutInfo", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/window/layout/WindowLayoutInfo;", "activity", "Landroid/app/Activity;", "Companion", "window_release"})
public interface WindowInfoTracker {
    @NotNull
    public static final Companion Companion = androidx.window.layout.WindowInfoTracker$Companion.$$INSTANCE;

    @NotNull
    public Flow<WindowLayoutInfo> windowLayoutInfo(@NotNull Activity var1);

    @JvmStatic
    @JvmName(name="getOrCreate")
    @NotNull
    public static WindowInfoTracker getOrCreate(@NotNull Context context) {
        return Companion.getOrCreate(context);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void overrideDecorator(@NotNull WindowInfoTrackerDecorator overridingDecorator) {
        Companion.overrideDecorator(overridingDecorator);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void reset() {
        Companion.reset();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/window/layout/WindowInfoTracker$Companion;", "", "()V", "DEBUG", "", "TAG", "", "decorator", "Landroidx/window/layout/WindowInfoTrackerDecorator;", "getOrCreate", "Landroidx/window/layout/WindowInfoTracker;", "context", "Landroid/content/Context;", "overrideDecorator", "", "overridingDecorator", "reset", "windowBackend", "Landroidx/window/layout/WindowBackend;", "windowBackend$window_release", "window_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final boolean DEBUG;
        @Nullable
        private static final String TAG;
        @NotNull
        private static WindowInfoTrackerDecorator decorator;

        private Companion() {
        }

        @JvmStatic
        @JvmName(name="getOrCreate")
        @NotNull
        public final WindowInfoTracker getOrCreate(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            WindowInfoTrackerImpl repo = new WindowInfoTrackerImpl(WindowMetricsCalculatorCompat.INSTANCE, this.windowBackend$window_release(context));
            return decorator.decorate(repo);
        }

        @NotNull
        public final WindowBackend windowBackend$window_release(@NotNull Context context) {
            Object extensionBackend;
            Object object;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                ExtensionWindowLayoutInfoBackend extensionWindowLayoutInfoBackend;
                object = SafeWindowLayoutComponentProvider.INSTANCE.getWindowLayoutComponent();
                if (object == null) {
                    extensionWindowLayoutInfoBackend = null;
                } else {
                    WindowLayoutComponent p0 = object;
                    boolean bl = false;
                    extensionWindowLayoutInfoBackend = new ExtensionWindowLayoutInfoBackend(p0);
                }
                object = extensionWindowLayoutInfoBackend;
            }
            catch (Throwable t) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"Failed to load WindowExtensions");
                }
                object = null;
            }
            Object object2 = extensionBackend = object;
            return object2 == null ? (WindowBackend)SidecarWindowBackend.Companion.getInstance(context) : (WindowBackend)object2;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final void overrideDecorator(@NotNull WindowInfoTrackerDecorator overridingDecorator) {
            Intrinsics.checkNotNullParameter((Object)overridingDecorator, (String)"overridingDecorator");
            decorator = overridingDecorator;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final void reset() {
            decorator = EmptyDecorator.INSTANCE;
        }

        static {
            $$INSTANCE = new Companion();
            TAG = Reflection.getOrCreateKotlinClass(WindowInfoTracker.class).getSimpleName();
            decorator = EmptyDecorator.INSTANCE;
        }
    }
}

