/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.window.core.Version;
import androidx.window.layout.ExtensionInterfaceCompat;
import androidx.window.layout.SidecarAdapter;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.sidecar.SidecarDeviceState;
import androidx.window.sidecar.SidecarDisplayFeature;
import androidx.window.sidecar.SidecarInterface;
import androidx.window.sidecar.SidecarProvider;
import androidx.window.sidecar.SidecarWindowLayoutInfo;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 !2\u00020\u0001:\u0005!\"#$%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0007\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020 H\u0017R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroidx/window/layout/SidecarCompat;", "Landroidx/window/layout/ExtensionInterfaceCompat;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "sidecar", "Landroidx/window/sidecar/SidecarInterface;", "sidecarAdapter", "Landroidx/window/layout/SidecarAdapter;", "(Landroidx/window/sidecar/SidecarInterface;Landroidx/window/layout/SidecarAdapter;)V", "componentCallbackMap", "", "Landroid/app/Activity;", "Landroid/content/ComponentCallbacks;", "extensionCallback", "Landroidx/window/layout/ExtensionInterfaceCompat$ExtensionCallbackInterface;", "getSidecar", "()Landroidx/window/sidecar/SidecarInterface;", "windowListenerRegisteredContexts", "Landroid/os/IBinder;", "getWindowLayoutInfo", "Landroidx/window/layout/WindowLayoutInfo;", "activity", "onWindowLayoutChangeListenerAdded", "", "onWindowLayoutChangeListenerRemoved", "register", "windowToken", "registerConfigurationChangeListener", "setExtensionCallback", "unregisterComponentCallback", "validateExtensionInterface", "", "Companion", "DistinctElementCallback", "DistinctSidecarElementCallback", "FirstAttachAdapter", "TranslatingCallback", "window_release"})
public final class SidecarCompat
implements ExtensionInterfaceCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final SidecarInterface sidecar;
    @NotNull
    private final SidecarAdapter sidecarAdapter;
    @NotNull
    private final Map<IBinder, Activity> windowListenerRegisteredContexts;
    @NotNull
    private final Map<Activity, ComponentCallbacks> componentCallbackMap;
    @Nullable
    private ExtensionInterfaceCompat.ExtensionCallbackInterface extensionCallback;
    @NotNull
    private static final String TAG = "SidecarCompat";

    @VisibleForTesting
    public SidecarCompat(@VisibleForTesting @Nullable SidecarInterface sidecar, @NotNull SidecarAdapter sidecarAdapter) {
        Intrinsics.checkNotNullParameter((Object)sidecarAdapter, (String)"sidecarAdapter");
        this.sidecar = sidecar;
        this.sidecarAdapter = sidecarAdapter;
        this.windowListenerRegisteredContexts = new LinkedHashMap();
        this.componentCallbackMap = new LinkedHashMap();
    }

    @Nullable
    public final SidecarInterface getSidecar() {
        return this.sidecar;
    }

    public SidecarCompat(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(Companion.getSidecarCompat$window_release(context), new SidecarAdapter(null, 1, null));
    }

    @Override
    public void setExtensionCallback(@NotNull ExtensionInterfaceCompat.ExtensionCallbackInterface extensionCallback) {
        Intrinsics.checkNotNullParameter((Object)extensionCallback, (String)"extensionCallback");
        this.extensionCallback = new DistinctElementCallback(extensionCallback);
        SidecarInterface sidecarInterface = this.sidecar;
        if (sidecarInterface != null) {
            sidecarInterface.setSidecarCallback((SidecarInterface.SidecarCallback)new DistinctSidecarElementCallback(this.sidecarAdapter, new TranslatingCallback()));
        }
    }

    @VisibleForTesting
    @NotNull
    public final WindowLayoutInfo getWindowLayoutInfo(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        IBinder iBinder = Companion.getActivityWindowToken$window_release(activity);
        if (iBinder == null) {
            return new WindowLayoutInfo(CollectionsKt.emptyList());
        }
        IBinder windowToken = iBinder;
        SidecarInterface sidecarInterface = this.sidecar;
        SidecarWindowLayoutInfo windowLayoutInfo2 = sidecarInterface == null ? null : sidecarInterface.getWindowLayoutInfo(windowToken);
        SidecarInterface sidecarInterface2 = this.sidecar;
        Object object = sidecarInterface2 == null ? null : sidecarInterface2.getDeviceState();
        if (object == null) {
            object = new SidecarDeviceState();
        }
        return this.sidecarAdapter.translate(windowLayoutInfo2, (SidecarDeviceState)object);
    }

    @Override
    public void onWindowLayoutChangeListenerAdded(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        IBinder windowToken = Companion.getActivityWindowToken$window_release(activity);
        if (windowToken != null) {
            this.register(windowToken, activity);
        } else {
            FirstAttachAdapter attachAdapter = new FirstAttachAdapter(this, activity);
            activity.getWindow().getDecorView().addOnAttachStateChangeListener((View.OnAttachStateChangeListener)attachAdapter);
        }
    }

    public final void register(@NotNull IBinder windowToken, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)windowToken, (String)"windowToken");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.windowListenerRegisteredContexts.put(windowToken, activity);
        SidecarInterface sidecarInterface = this.sidecar;
        if (sidecarInterface != null) {
            sidecarInterface.onWindowLayoutChangeListenerAdded(windowToken);
        }
        if (this.windowListenerRegisteredContexts.size() == 1) {
            SidecarInterface sidecarInterface2 = this.sidecar;
            if (sidecarInterface2 != null) {
                sidecarInterface2.onDeviceStateListenersChanged(false);
            }
        }
        ExtensionInterfaceCompat.ExtensionCallbackInterface extensionCallbackInterface = this.extensionCallback;
        if (extensionCallbackInterface != null) {
            extensionCallbackInterface.onWindowLayoutChanged(activity, this.getWindowLayoutInfo(activity));
        }
        this.registerConfigurationChangeListener(activity);
    }

    private final void registerConfigurationChangeListener(Activity activity) {
        if (this.componentCallbackMap.get(activity) == null) {
            ComponentCallbacks configChangeObserver2 = new ComponentCallbacks(this, activity){
                final /* synthetic */ SidecarCompat this$0;
                final /* synthetic */ Activity $activity;
                {
                    this.this$0 = $receiver;
                    this.$activity = $activity;
                }

                public void onConfigurationChanged(@NotNull Configuration newConfig) {
                    Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
                    ExtensionInterfaceCompat.ExtensionCallbackInterface extensionCallbackInterface = SidecarCompat.access$getExtensionCallback$p(this.this$0);
                    if (extensionCallbackInterface != null) {
                        extensionCallbackInterface.onWindowLayoutChanged(this.$activity, this.this$0.getWindowLayoutInfo(this.$activity));
                    }
                }

                public void onLowMemory() {
                }
            };
            this.componentCallbackMap.put(activity, configChangeObserver2);
            activity.registerComponentCallbacks(configChangeObserver2);
        }
    }

    @Override
    public void onWindowLayoutChangeListenerRemoved(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        IBinder iBinder = Companion.getActivityWindowToken$window_release(activity);
        if (iBinder == null) {
            return;
        }
        IBinder windowToken = iBinder;
        SidecarInterface sidecarInterface = this.sidecar;
        if (sidecarInterface != null) {
            sidecarInterface.onWindowLayoutChangeListenerRemoved(windowToken);
        }
        this.unregisterComponentCallback(activity);
        boolean isLast = this.windowListenerRegisteredContexts.size() == 1;
        this.windowListenerRegisteredContexts.remove(windowToken);
        if (isLast) {
            SidecarInterface sidecarInterface2 = this.sidecar;
            if (sidecarInterface2 != null) {
                sidecarInterface2.onDeviceStateListenersChanged(true);
            }
        }
    }

    private final void unregisterComponentCallback(Activity activity) {
        ComponentCallbacks configChangeObserver2 = this.componentCallbackMap.get(activity);
        activity.unregisterComponentCallbacks(configChangeObserver2);
        this.componentCallbackMap.remove(activity);
    }

    @Override
    @SuppressLint(value={"BanUncheckedReflection"})
    public boolean validateExtensionInterface() {
        boolean bl;
        try {
            block30: {
                Object methodGetPosture;
                block29: {
                    Class<?> rtUnregisterWindowLayoutChangeListener;
                    Method methodUnregisterWindowLayoutChangeListener;
                    Method method;
                    Class<?> rtRegisterWindowLayoutChangeListener;
                    Method methodRegisterWindowLayoutChangeListener;
                    SidecarInterface sidecarInterface;
                    Method method2;
                    Class<?> rtGetWindowLayoutInfo;
                    Method methodGetWindowLayoutInfo;
                    SidecarInterface sidecarInterface2;
                    Method method3;
                    Class<?> rSetSidecarCallback;
                    Method methodSetSidecarCallback;
                    Method method4;
                    SidecarInterface sidecarInterface3 = this.sidecar;
                    if (sidecarInterface3 == null) {
                        method4 = null;
                    } else {
                        Class<?> clazz = sidecarInterface3.getClass();
                        if (clazz == null) {
                            method4 = null;
                        } else {
                            Class[] classArray = new Class[]{SidecarInterface.SidecarCallback.class};
                            method4 = clazz.getMethod("setSidecarCallback", classArray);
                        }
                    }
                    Method method5 = methodSetSidecarCallback = method4;
                    Class<Object> clazz = rSetSidecarCallback = method5 == null ? null : method5.getReturnType();
                    if (!Intrinsics.areEqual(rSetSidecarCallback, Void.TYPE)) {
                        throw new NoSuchMethodException(Intrinsics.stringPlus((String)"Illegal return type for 'setSidecarCallback': ", rSetSidecarCallback));
                    }
                    SidecarInterface sidecarInterface4 = this.sidecar;
                    SidecarDeviceState tmpDeviceState = sidecarInterface4 == null ? null : sidecarInterface4.getDeviceState();
                    SidecarInterface sidecarInterface5 = this.sidecar;
                    if (sidecarInterface5 != null) {
                        sidecarInterface5.onDeviceStateListenersChanged(true);
                    }
                    SidecarInterface sidecarInterface6 = this.sidecar;
                    if (sidecarInterface6 == null) {
                        method3 = null;
                    } else {
                        Class<?> clazz2 = sidecarInterface6.getClass();
                        if (clazz2 == null) {
                            method3 = null;
                        } else {
                            sidecarInterface2 = new SidecarInterface[]{IBinder.class};
                            method3 = clazz2.getMethod("getWindowLayoutInfo", (Class<?>)sidecarInterface2);
                        }
                    }
                    Method method6 = methodGetWindowLayoutInfo = method3;
                    Class<Object> clazz3 = rtGetWindowLayoutInfo = method6 == null ? null : method6.getReturnType();
                    if (!Intrinsics.areEqual(rtGetWindowLayoutInfo, SidecarWindowLayoutInfo.class)) {
                        throw new NoSuchMethodException(Intrinsics.stringPlus((String)"Illegal return type for 'getWindowLayoutInfo': ", rtGetWindowLayoutInfo));
                    }
                    sidecarInterface2 = this.sidecar;
                    if (sidecarInterface2 == null) {
                        method2 = null;
                    } else {
                        Class<?> clazz4 = sidecarInterface2.getClass();
                        if (clazz4 == null) {
                            method2 = null;
                        } else {
                            sidecarInterface = new SidecarInterface[]{IBinder.class};
                            method2 = clazz4.getMethod("onWindowLayoutChangeListenerAdded", (Class<?>)sidecarInterface);
                        }
                    }
                    Method method7 = methodRegisterWindowLayoutChangeListener = method2;
                    Class<Object> clazz5 = rtRegisterWindowLayoutChangeListener = method7 == null ? null : method7.getReturnType();
                    if (!Intrinsics.areEqual(rtRegisterWindowLayoutChangeListener, Void.TYPE)) {
                        throw new NoSuchMethodException(Intrinsics.stringPlus((String)"Illegal return type for 'onWindowLayoutChangeListenerAdded': ", rtRegisterWindowLayoutChangeListener));
                    }
                    sidecarInterface = this.sidecar;
                    if (sidecarInterface == null) {
                        method = null;
                    } else {
                        Class<?> clazz6 = sidecarInterface.getClass();
                        if (clazz6 == null) {
                            method = null;
                        } else {
                            Class[] classArray = new Class[]{IBinder.class};
                            method = clazz6.getMethod("onWindowLayoutChangeListenerRemoved", classArray);
                        }
                    }
                    Method method8 = methodUnregisterWindowLayoutChangeListener = method;
                    Class<Object> clazz7 = rtUnregisterWindowLayoutChangeListener = method8 == null ? null : method8.getReturnType();
                    if (!Intrinsics.areEqual(rtUnregisterWindowLayoutChangeListener, Void.TYPE)) {
                        throw new NoSuchMethodException(Intrinsics.stringPlus((String)"Illegal return type for 'onWindowLayoutChangeListenerRemoved': ", rtUnregisterWindowLayoutChangeListener));
                    }
                    tmpDeviceState = new SidecarDeviceState();
                    try {
                        tmpDeviceState.posture = 3;
                    }
                    catch (NoSuchFieldError error) {
                        Object[] objectArray = new Class[]{Integer.TYPE};
                        Method methodSetPosture = SidecarDeviceState.class.getMethod("setPosture", (Class<?>[])objectArray);
                        objectArray = new Object[]{3};
                        methodSetPosture.invoke((Object)tmpDeviceState, objectArray);
                        methodGetPosture = SidecarDeviceState.class.getMethod("getPosture", new Class[0]);
                        Object object = ((Method)methodGetPosture).invoke((Object)tmpDeviceState, new Object[0]);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        int posture = (Integer)object;
                        if (posture == 3) break block29;
                        throw new Exception("Invalid device posture getter/setter");
                    }
                }
                SidecarDisplayFeature displayFeature = new SidecarDisplayFeature();
                methodGetPosture = displayFeature.getRect();
                Intrinsics.checkNotNullExpressionValue((Object)methodGetPosture, (String)"displayFeature.rect");
                Rect tmpRect = methodGetPosture;
                displayFeature.setRect(tmpRect);
                int tmpType = displayFeature.getType();
                displayFeature.setType(1);
                SidecarWindowLayoutInfo windowLayoutInfo2 = new SidecarWindowLayoutInfo();
                try {
                    List list = windowLayoutInfo2.displayFeatures;
                }
                catch (NoSuchFieldError error) {
                    List featureList = new ArrayList();
                    featureList.add(displayFeature);
                    Object[] objectArray = new Class[]{List.class};
                    Method methodSetFeatures = SidecarWindowLayoutInfo.class.getMethod("setDisplayFeatures", (Class<?>[])objectArray);
                    objectArray = new Object[]{featureList};
                    methodSetFeatures.invoke((Object)windowLayoutInfo2, objectArray);
                    Method methodGetFeatures = SidecarWindowLayoutInfo.class.getMethod("getDisplayFeatures", new Class[0]);
                    Object object = methodGetFeatures.invoke((Object)windowLayoutInfo2, new Object[0]);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<androidx.window.sidecar.SidecarDisplayFeature>");
                    }
                    List resultDisplayFeatures = (List)object;
                    if (Intrinsics.areEqual((Object)featureList, (Object)resultDisplayFeatures)) break block30;
                    throw new Exception("Invalid display feature getter/setter");
                }
            }
            bl = true;
        }
        catch (Throwable t) {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/window/layout/SidecarCompat$FirstAttachAdapter;", "Landroid/view/View$OnAttachStateChangeListener;", "sidecarCompat", "Landroidx/window/layout/SidecarCompat;", "activity", "Landroid/app/Activity;", "(Landroidx/window/layout/SidecarCompat;Landroid/app/Activity;)V", "activityWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "onViewAttachedToWindow", "", "view", "Landroid/view/View;", "onViewDetachedFromWindow", "window_release"})
    private static final class FirstAttachAdapter
    implements View.OnAttachStateChangeListener {
        @NotNull
        private final SidecarCompat sidecarCompat;
        @NotNull
        private final WeakReference<Activity> activityWeakReference;

        public FirstAttachAdapter(@NotNull SidecarCompat sidecarCompat, @NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)sidecarCompat, (String)"sidecarCompat");
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.sidecarCompat = sidecarCompat;
            this.activityWeakReference = new WeakReference<Activity>(activity);
        }

        public void onViewAttachedToWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            Activity activity = (Activity)this.activityWeakReference.get();
            IBinder token = Companion.getActivityWindowToken$window_release(activity);
            if (activity == null) {
                return;
            }
            if (token == null) {
                return;
            }
            this.sidecarCompat.register(token, activity);
        }

        public void onViewDetachedFromWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\f"}, d2={"Landroidx/window/layout/SidecarCompat$TranslatingCallback;", "Landroidx/window/sidecar/SidecarInterface$SidecarCallback;", "(Landroidx/window/layout/SidecarCompat;)V", "onDeviceStateChanged", "", "newDeviceState", "Landroidx/window/sidecar/SidecarDeviceState;", "onWindowLayoutChanged", "windowToken", "Landroid/os/IBinder;", "newLayout", "Landroidx/window/sidecar/SidecarWindowLayoutInfo;", "window_release"})
    public final class TranslatingCallback
    implements SidecarInterface.SidecarCallback {
        public TranslatingCallback() {
            Intrinsics.checkNotNullParameter((Object)SidecarCompat.this, (String)"this$0");
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"SyntheticAccessor"})
        public void onDeviceStateChanged(@NotNull SidecarDeviceState newDeviceState) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)newDeviceState, (String)"newDeviceState");
            Iterable iterable = SidecarCompat.this.windowListenerRegisteredContexts.values();
            SidecarCompat sidecarCompat = SidecarCompat.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SidecarWindowLayoutInfo sidecarWindowLayoutInfo;
                Activity activity = (Activity)element$iv;
                boolean bl = false;
                IBinder iBinder = Companion.getActivityWindowToken$window_release(activity);
                if (iBinder == null) {
                    sidecarWindowLayoutInfo = null;
                } else {
                    IBinder windowToken = iBinder;
                    boolean bl2 = false;
                    SidecarInterface sidecarInterface = sidecarCompat.getSidecar();
                    sidecarWindowLayoutInfo = sidecarInterface == null ? null : sidecarInterface.getWindowLayoutInfo(windowToken);
                }
                SidecarWindowLayoutInfo layoutInfo = sidecarWindowLayoutInfo;
                ExtensionInterfaceCompat.ExtensionCallbackInterface extensionCallbackInterface = sidecarCompat.extensionCallback;
                if (extensionCallbackInterface == null) continue;
                extensionCallbackInterface.onWindowLayoutChanged(activity, sidecarCompat.sidecarAdapter.translate(layoutInfo, newDeviceState));
            }
        }

        @SuppressLint(value={"SyntheticAccessor"})
        public void onWindowLayoutChanged(@NotNull IBinder windowToken, @NotNull SidecarWindowLayoutInfo newLayout) {
            Intrinsics.checkNotNullParameter((Object)windowToken, (String)"windowToken");
            Intrinsics.checkNotNullParameter((Object)newLayout, (String)"newLayout");
            Activity activity = (Activity)SidecarCompat.this.windowListenerRegisteredContexts.get(windowToken);
            if (activity == null) {
                Log.w((String)SidecarCompat.TAG, (String)"Unable to resolve activity from window token. Missing a call to #onWindowLayoutChangeListenerAdded()?");
                return;
            }
            SidecarAdapter sidecarAdapter = SidecarCompat.this.sidecarAdapter;
            SidecarInterface sidecarInterface = SidecarCompat.this.getSidecar();
            Object object = sidecarInterface == null ? null : sidecarInterface.getDeviceState();
            if (object == null) {
                object = new SidecarDeviceState();
            }
            WindowLayoutInfo layoutInfo = sidecarAdapter.translate(newLayout, (SidecarDeviceState)object);
            ExtensionInterfaceCompat.ExtensionCallbackInterface extensionCallbackInterface = SidecarCompat.this.extensionCallback;
            if (extensionCallbackInterface != null) {
                extensionCallbackInterface.onWindowLayoutChanged(activity, layoutInfo);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007H\u0016R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/window/layout/SidecarCompat$DistinctElementCallback;", "Landroidx/window/layout/ExtensionInterfaceCompat$ExtensionCallbackInterface;", "callbackInterface", "(Landroidx/window/layout/ExtensionInterfaceCompat$ExtensionCallbackInterface;)V", "activityWindowLayoutInfo", "Ljava/util/WeakHashMap;", "Landroid/app/Activity;", "Landroidx/window/layout/WindowLayoutInfo;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "onWindowLayoutChanged", "", "activity", "newLayout", "window_release"})
    private static final class DistinctElementCallback
    implements ExtensionInterfaceCompat.ExtensionCallbackInterface {
        @NotNull
        private final ExtensionInterfaceCompat.ExtensionCallbackInterface callbackInterface;
        @NotNull
        private final ReentrantLock lock;
        @GuardedBy(value="mLock")
        @NotNull
        private final WeakHashMap<Activity, WindowLayoutInfo> activityWindowLayoutInfo;

        public DistinctElementCallback(@NotNull ExtensionInterfaceCompat.ExtensionCallbackInterface callbackInterface) {
            Intrinsics.checkNotNullParameter((Object)callbackInterface, (String)"callbackInterface");
            this.callbackInterface = callbackInterface;
            this.lock = new ReentrantLock();
            this.activityWindowLayoutInfo = new WeakHashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWindowLayoutChanged(@NotNull Activity activity, @NotNull WindowLayoutInfo newLayout) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)newLayout, (String)"newLayout");
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                WindowLayoutInfo lastInfo = this.activityWindowLayoutInfo.get(activity);
                if (Intrinsics.areEqual((Object)newLayout, (Object)lastInfo)) {
                    return;
                }
                WindowLayoutInfo windowLayoutInfo2 = this.activityWindowLayoutInfo.put(activity, newLayout);
            }
            finally {
                lock.unlock();
            }
            this.callbackInterface.onWindowLayoutChanged(activity, newLayout);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/window/layout/SidecarCompat$DistinctSidecarElementCallback;", "Landroidx/window/sidecar/SidecarInterface$SidecarCallback;", "sidecarAdapter", "Landroidx/window/layout/SidecarAdapter;", "callbackInterface", "(Landroidx/window/layout/SidecarAdapter;Landroidx/window/sidecar/SidecarInterface$SidecarCallback;)V", "lastDeviceState", "Landroidx/window/sidecar/SidecarDeviceState;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "mActivityWindowLayoutInfo", "Ljava/util/WeakHashMap;", "Landroid/os/IBinder;", "Landroidx/window/sidecar/SidecarWindowLayoutInfo;", "onDeviceStateChanged", "", "newDeviceState", "onWindowLayoutChanged", "token", "newLayout", "window_release"})
    private static final class DistinctSidecarElementCallback
    implements SidecarInterface.SidecarCallback {
        @NotNull
        private final SidecarAdapter sidecarAdapter;
        @NotNull
        private final SidecarInterface.SidecarCallback callbackInterface;
        @NotNull
        private final ReentrantLock lock;
        @GuardedBy(value="lock")
        @Nullable
        private SidecarDeviceState lastDeviceState;
        @GuardedBy(value="mLock")
        @NotNull
        private final WeakHashMap<IBinder, SidecarWindowLayoutInfo> mActivityWindowLayoutInfo;

        public DistinctSidecarElementCallback(@NotNull SidecarAdapter sidecarAdapter, @NotNull SidecarInterface.SidecarCallback callbackInterface) {
            Intrinsics.checkNotNullParameter((Object)sidecarAdapter, (String)"sidecarAdapter");
            Intrinsics.checkNotNullParameter((Object)callbackInterface, (String)"callbackInterface");
            this.sidecarAdapter = sidecarAdapter;
            this.callbackInterface = callbackInterface;
            this.lock = new ReentrantLock();
            this.mActivityWindowLayoutInfo = new WeakHashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDeviceStateChanged(@NotNull SidecarDeviceState newDeviceState) {
            Intrinsics.checkNotNullParameter((Object)newDeviceState, (String)"newDeviceState");
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                if (this.sidecarAdapter.isEqualSidecarDeviceState(this.lastDeviceState, newDeviceState)) {
                    return;
                }
                this.lastDeviceState = newDeviceState;
                this.callbackInterface.onDeviceStateChanged(newDeviceState);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowLayoutChanged(@NotNull IBinder token, @NotNull SidecarWindowLayoutInfo newLayout) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)newLayout, (String)"newLayout");
            ReentrantLock reentrantLock = this.lock;
            synchronized (reentrantLock) {
                boolean bl = false;
                SidecarWindowLayoutInfo lastInfo = this.mActivityWindowLayoutInfo.get(token);
                if (this.sidecarAdapter.isEqualSidecarWindowLayoutInfo(lastInfo, newLayout)) {
                    return;
                }
                SidecarWindowLayoutInfo sidecarWindowLayoutInfo = this.mActivityWindowLayoutInfo.put(token, newLayout);
            }
            this.callbackInterface.onWindowLayoutChanged(token, newLayout);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Landroidx/window/layout/SidecarCompat$Companion;", "", "()V", "TAG", "", "sidecarVersion", "Landroidx/window/core/Version;", "getSidecarVersion", "()Landroidx/window/core/Version;", "getActivityWindowToken", "Landroid/os/IBinder;", "activity", "Landroid/app/Activity;", "getActivityWindowToken$window_release", "getSidecarCompat", "Landroidx/window/sidecar/SidecarInterface;", "context", "Landroid/content/Context;", "getSidecarCompat$window_release", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Version getSidecarVersion() {
            Version version;
            try {
                String vendorVersion = SidecarProvider.getApiVersion();
                version = !TextUtils.isEmpty((CharSequence)vendorVersion) ? Version.Companion.parse(vendorVersion) : null;
            }
            catch (NoClassDefFoundError e) {
                version = null;
            }
            catch (UnsupportedOperationException e) {
                version = null;
            }
            return version;
        }

        @Nullable
        public final SidecarInterface getSidecarCompat$window_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return SidecarProvider.getSidecarImpl((Context)context.getApplicationContext());
        }

        @Nullable
        public final IBinder getActivityWindowToken$window_release(@Nullable Activity activity) {
            Object object;
            Activity activity2 = activity;
            if (activity2 == null) {
                object = null;
            } else {
                Window window = activity2.getWindow();
                if (window == null) {
                    object = null;
                } else {
                    WindowManager.LayoutParams layoutParams = window.getAttributes();
                    object = layoutParams == null ? null : layoutParams.token;
                }
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

