/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawableWithAnimatedVisibilityChange;

abstract class DrawingDelegate<S extends BaseProgressIndicatorSpec> {
    S spec;
    protected DrawableWithAnimatedVisibilityChange drawable;

    public DrawingDelegate(S spec) {
        this.spec = spec;
    }

    abstract int getPreferredWidth();

    abstract int getPreferredHeight();

    abstract void adjustCanvas(@NonNull Canvas var1, @FloatRange(from=0.0, to=1.0) float var2);

    abstract void fillIndicator(@NonNull Canvas var1, @NonNull Paint var2, @FloatRange(from=0.0, to=1.0) float var3, @FloatRange(from=0.0, to=1.0) float var4, @ColorInt int var5);

    abstract void fillTrack(@NonNull Canvas var1, @NonNull Paint var2);

    protected void registerDrawable(@NonNull DrawableWithAnimatedVisibilityChange drawable2) {
        this.drawable = drawable2;
    }

    void validateSpecAndAdjustCanvas(@NonNull Canvas canvas, @FloatRange(from=0.0, to=1.0) float trackThicknessFraction) {
        ((BaseProgressIndicatorSpec)this.spec).validateSpec();
        this.adjustCanvas(canvas, trackThicknessFraction);
    }
}

