/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import androidx.window.R;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.embedding.ActivityFilter;
import androidx.window.embedding.ActivityRule;
import androidx.window.embedding.EmbeddingRule;
import androidx.window.embedding.SplitPairFilter;
import androidx.window.embedding.SplitPairRule;
import androidx.window.embedding.SplitPlaceholderRule;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J%\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ \u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002\u00a8\u0006\u001f"}, d2={"Landroidx/window/embedding/SplitRuleParser;", "", "()V", "buildClassName", "Landroid/content/ComponentName;", "pkg", "", "clsSeq", "", "parseActivityFilter", "Landroidx/window/embedding/ActivityFilter;", "context", "Landroid/content/Context;", "parser", "Landroid/content/res/XmlResourceParser;", "parseSplitActivityRule", "Landroidx/window/embedding/ActivityRule;", "parseSplitPairFilter", "Landroidx/window/embedding/SplitPairFilter;", "parseSplitPairRule", "Landroidx/window/embedding/SplitPairRule;", "parseSplitPlaceholderRule", "Landroidx/window/embedding/SplitPlaceholderRule;", "parseSplitRules", "", "Landroidx/window/embedding/EmbeddingRule;", "staticRuleResourceId", "", "parseSplitRules$window_release", "parseSplitXml", "splitResourceId", "window_release"})
@ExperimentalWindowApi
public final class SplitRuleParser {
    @Nullable
    public final Set<EmbeddingRule> parseSplitRules$window_release(@NotNull Context context, int staticRuleResourceId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.parseSplitXml(context, staticRuleResourceId);
    }

    private final Set<EmbeddingRule> parseSplitXml(Context context, int splitResourceId) {
        Resources resources = context.getResources();
        XmlResourceParser parser = null;
        try {
            XmlResourceParser xmlResourceParser = resources.getXml(splitResourceId);
            Intrinsics.checkNotNullExpressionValue((Object)xmlResourceParser, (String)"resources.getXml(splitResourceId)");
            parser = xmlResourceParser;
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
        HashSet<EmbeddingRule> splitRuleConfigs = new HashSet<EmbeddingRule>();
        int depth = parser.getDepth();
        int type = parser.next();
        SplitPairRule lastSplitPairConfig = null;
        SplitPlaceholderRule lastSplitPlaceholderConfig = null;
        ActivityRule lastSplitActivityConfig = null;
        while (type != 1 && (type != 3 || parser.getDepth() > depth)) {
            block26: {
                if (parser.getEventType() != 2 || Intrinsics.areEqual((Object)"split-config", (Object)parser.getName())) {
                    type = parser.next();
                    continue;
                }
                String string = parser.getName();
                if (string == null) break block26;
                int n = -1;
                switch (string.hashCode()) {
                    case 520447504: {
                        if (string.equals("SplitPairRule")) {
                            n = 1;
                        }
                        break;
                    }
                    case 2050988213: {
                        if (string.equals("SplitPlaceholderRule")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1793077963: {
                        if (string.equals("ActivityRule")) {
                            n = 3;
                        }
                        break;
                    }
                    case 511422343: {
                        if (string.equals("ActivityFilter")) {
                            n = 4;
                        }
                        break;
                    }
                    case 1579230604: {
                        if (string.equals("SplitPairFilter")) {
                            n = 5;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        SplitPairRule splitConfig;
                        lastSplitPairConfig = splitConfig = this.parseSplitPairRule(context, parser);
                        splitRuleConfigs.add(lastSplitPairConfig);
                        lastSplitPlaceholderConfig = null;
                        lastSplitActivityConfig = null;
                        break;
                    }
                    case 2: {
                        SplitPlaceholderRule placeholderConfig;
                        lastSplitPlaceholderConfig = placeholderConfig = this.parseSplitPlaceholderRule(context, parser);
                        splitRuleConfigs.add(lastSplitPlaceholderConfig);
                        lastSplitActivityConfig = null;
                        lastSplitPairConfig = null;
                        break;
                    }
                    case 5: {
                        if (lastSplitPairConfig == null) {
                            throw new IllegalArgumentException("Found orphaned SplitPairFilter outside of SplitPairRule");
                        }
                        SplitPairFilter splitFilter = this.parseSplitPairFilter(context, parser);
                        splitRuleConfigs.remove(lastSplitPairConfig);
                        lastSplitPairConfig = lastSplitPairConfig.plus$window_release(splitFilter);
                        splitRuleConfigs.add(lastSplitPairConfig);
                        break;
                    }
                    case 3: {
                        ActivityRule activityConfig = this.parseSplitActivityRule(context, parser);
                        splitRuleConfigs.add(activityConfig);
                        lastSplitPairConfig = null;
                        lastSplitPlaceholderConfig = null;
                        lastSplitActivityConfig = activityConfig;
                        break;
                    }
                    case 4: {
                        if (lastSplitActivityConfig == null && lastSplitPlaceholderConfig == null) {
                            throw new IllegalArgumentException("Found orphaned ActivityFilter");
                        }
                        ActivityFilter activityFilter = this.parseActivityFilter(context, parser);
                        if (lastSplitActivityConfig != null) {
                            splitRuleConfigs.remove(lastSplitActivityConfig);
                            lastSplitActivityConfig = lastSplitActivityConfig.plus$window_release(activityFilter);
                            splitRuleConfigs.add(lastSplitActivityConfig);
                            break;
                        }
                        if (lastSplitPlaceholderConfig == null) break;
                        splitRuleConfigs.remove(lastSplitPlaceholderConfig);
                        lastSplitPlaceholderConfig = lastSplitPlaceholderConfig.plus$window_release(activityFilter);
                        splitRuleConfigs.add(lastSplitPlaceholderConfig);
                    }
                }
            }
            type = parser.next();
        }
        return splitRuleConfigs;
    }

    private final SplitPairRule parseSplitPairRule(Context context, XmlResourceParser parser) {
        TypedArray typedArray;
        float ratio = 0.0f;
        int minWidth = 0;
        int minSmallestWidth = 0;
        int layoutDir = 0;
        boolean finishPrimaryWithSecondary = false;
        boolean finishSecondaryWithPrimary = false;
        boolean clearTop = false;
        TypedArray $this$parseSplitPairRule_u24lambda_u2d0 = typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.SplitPairRule, 0, 0);
        boolean bl = false;
        ratio = $this$parseSplitPairRule_u24lambda_u2d0.getFloat(R.styleable.SplitPairRule_splitRatio, 0.0f);
        minWidth = (int)$this$parseSplitPairRule_u24lambda_u2d0.getDimension(R.styleable.SplitPairRule_splitMinWidth, 0.0f);
        minSmallestWidth = (int)$this$parseSplitPairRule_u24lambda_u2d0.getDimension(R.styleable.SplitPairRule_splitMinSmallestWidth, 0.0f);
        layoutDir = $this$parseSplitPairRule_u24lambda_u2d0.getInt(R.styleable.SplitPairRule_splitLayoutDirection, 3);
        finishPrimaryWithSecondary = $this$parseSplitPairRule_u24lambda_u2d0.getBoolean(R.styleable.SplitPairRule_finishPrimaryWithSecondary, false);
        finishSecondaryWithPrimary = $this$parseSplitPairRule_u24lambda_u2d0.getBoolean(R.styleable.SplitPairRule_finishSecondaryWithPrimary, true);
        clearTop = $this$parseSplitPairRule_u24lambda_u2d0.getBoolean(R.styleable.SplitPairRule_clearTop, false);
        return new SplitPairRule(SetsKt.emptySet(), finishPrimaryWithSecondary, finishSecondaryWithPrimary, clearTop, minWidth, minSmallestWidth, ratio, layoutDir);
    }

    private final SplitPlaceholderRule parseSplitPlaceholderRule(Context context, XmlResourceParser parser) {
        TypedArray typedArray;
        String placeholderActivityIntentName = null;
        float ratio = 0.0f;
        int minWidth = 0;
        int minSmallestWidth = 0;
        int layoutDir = 0;
        TypedArray $this$parseSplitPlaceholderRule_u24lambda_u2d1 = typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.SplitPlaceholderRule, 0, 0);
        boolean bl = false;
        placeholderActivityIntentName = $this$parseSplitPlaceholderRule_u24lambda_u2d1.getString(R.styleable.SplitPlaceholderRule_placeholderActivityName);
        ratio = $this$parseSplitPlaceholderRule_u24lambda_u2d1.getFloat(R.styleable.SplitPlaceholderRule_splitRatio, 0.0f);
        minWidth = (int)$this$parseSplitPlaceholderRule_u24lambda_u2d1.getDimension(R.styleable.SplitPlaceholderRule_splitMinWidth, 0.0f);
        minSmallestWidth = (int)$this$parseSplitPlaceholderRule_u24lambda_u2d1.getDimension(R.styleable.SplitPlaceholderRule_splitMinSmallestWidth, 0.0f);
        layoutDir = $this$parseSplitPlaceholderRule_u24lambda_u2d1.getInt(R.styleable.SplitPlaceholderRule_splitLayoutDirection, 3);
        String packageName = context.getApplicationContext().getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        ComponentName placeholderActivityClassName = this.buildClassName(packageName, placeholderActivityIntentName);
        Set set = SetsKt.emptySet();
        Intent intent = new Intent().setComponent(placeholderActivityClassName);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent().setComponent(pl\u2026eholderActivityClassName)");
        return new SplitPlaceholderRule(set, intent, minWidth, minSmallestWidth, ratio, layoutDir);
    }

    private final SplitPairFilter parseSplitPairFilter(Context context, XmlResourceParser parser) {
        TypedArray typedArray;
        String primaryActivityName = null;
        String secondaryActivityIntentName = null;
        String secondaryActivityAction = null;
        TypedArray $this$parseSplitPairFilter_u24lambda_u2d2 = typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.SplitPairFilter, 0, 0);
        boolean bl = false;
        primaryActivityName = $this$parseSplitPairFilter_u24lambda_u2d2.getString(R.styleable.SplitPairFilter_primaryActivityName);
        secondaryActivityIntentName = $this$parseSplitPairFilter_u24lambda_u2d2.getString(R.styleable.SplitPairFilter_secondaryActivityName);
        secondaryActivityAction = $this$parseSplitPairFilter_u24lambda_u2d2.getString(R.styleable.SplitPairFilter_secondaryActivityAction);
        String packageName = context.getApplicationContext().getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        ComponentName primaryActivityClassName = this.buildClassName(packageName, primaryActivityName);
        ComponentName secondaryActivityClassName = this.buildClassName(packageName, secondaryActivityIntentName);
        return new SplitPairFilter(primaryActivityClassName, secondaryActivityClassName, secondaryActivityAction);
    }

    private final ActivityRule parseSplitActivityRule(Context context, XmlResourceParser parser) {
        TypedArray typedArray;
        boolean alwaysExpand = false;
        TypedArray $this$parseSplitActivityRule_u24lambda_u2d3 = typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.ActivityRule, 0, 0);
        boolean bl = false;
        alwaysExpand = $this$parseSplitActivityRule_u24lambda_u2d3.getBoolean(R.styleable.ActivityRule_alwaysExpand, false);
        return new ActivityRule(SetsKt.emptySet(), alwaysExpand);
    }

    private final ActivityFilter parseActivityFilter(Context context, XmlResourceParser parser) {
        TypedArray typedArray;
        String activityName = null;
        String activityIntentAction = null;
        TypedArray $this$parseActivityFilter_u24lambda_u2d4 = typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)parser, R.styleable.ActivityFilter, 0, 0);
        boolean bl = false;
        activityName = $this$parseActivityFilter_u24lambda_u2d4.getString(R.styleable.ActivityFilter_activityName);
        activityIntentAction = $this$parseActivityFilter_u24lambda_u2d4.getString(R.styleable.ActivityFilter_activityAction);
        String packageName = context.getApplicationContext().getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        return new ActivityFilter(this.buildClassName(packageName, activityName), activityIntentAction);
    }

    private final ComponentName buildClassName(String pkg, CharSequence clsSeq) {
        if (clsSeq == null || clsSeq.length() == 0) {
            throw new IllegalArgumentException("Activity name must not be null");
        }
        String cls = ((Object)clsSeq).toString();
        char c = cls.charAt(0);
        if (c == '.') {
            return new ComponentName(pkg, Intrinsics.stringPlus((String)pkg, (Object)cls));
        }
        String pkgString = pkg;
        String clsString = cls;
        int pkgDividerIndex = StringsKt.indexOf$default((CharSequence)cls, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (pkgDividerIndex > 0) {
            String string = cls;
            int n = 0;
            String string2 = string.substring(n, pkgDividerIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            pkgString = string2;
            string = cls;
            n = pkgDividerIndex + 1;
            string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            clsString = string2;
        }
        if (!Intrinsics.areEqual((Object)clsString, (Object)"*") && StringsKt.indexOf$default((CharSequence)clsString, (char)'.', (int)0, (boolean)false, (int)6, null) < 0) {
            StringBuilder b = new StringBuilder(pkgString);
            b.append('.');
            b.append(clsString);
            return new ComponentName(pkgString, b.toString());
        }
        return new ComponentName(pkgString, clsString);
    }
}

