/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.os.Handler;
import android.os.Process;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.core.provider.CalleeHandler;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class RequestExecutor {
    private RequestExecutor() {
    }

    static <T> void execute(@NonNull Executor executor, @NonNull Callable<T> callable, @NonNull Consumer<T> consumer) {
        Handler calleeHandler = CalleeHandler.create();
        executor.execute(new ReplyRunnable<T>(calleeHandler, callable, consumer));
    }

    static <T> T submit(@NonNull ExecutorService executor, @NonNull Callable<T> callable, @IntRange(from=0L) int timeoutMillis) throws InterruptedException {
        Future<T> future = executor.submit(callable);
        try {
            return future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (TimeoutException e) {
            throw new InterruptedException("timeout");
        }
    }

    static ThreadPoolExecutor createDefaultExecutor(@NonNull String threadName, int threadPriority, @IntRange(from=0L) int keepAliveTimeInMillis) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(threadName, threadPriority);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, (long)keepAliveTimeInMillis, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), threadFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    static Executor createHandlerExecutor(@NonNull Handler handler) {
        return new HandlerExecutor(handler);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private String mThreadName;
        private int mPriority;

        DefaultThreadFactory(@NonNull String threadName, int priority) {
            this.mThreadName = threadName;
            this.mPriority = priority;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new ProcessPriorityThread(runnable, this.mThreadName, this.mPriority);
        }

        private static class ProcessPriorityThread
        extends Thread {
            private final int mPriority;

            ProcessPriorityThread(Runnable target, String name, int priority) {
                super(target, name);
                this.mPriority = priority;
            }

            @Override
            public void run() {
                Process.setThreadPriority((int)this.mPriority);
                super.run();
            }
        }
    }

    private static class ReplyRunnable<T>
    implements Runnable {
        @NonNull
        private Callable<T> mCallable;
        @NonNull
        private Consumer<T> mConsumer;
        @NonNull
        private Handler mHandler;

        ReplyRunnable(@NonNull Handler handler, @NonNull Callable<T> callable, @NonNull Consumer<T> consumer) {
            this.mCallable = callable;
            this.mConsumer = consumer;
            this.mHandler = handler;
        }

        @Override
        public void run() {
            T t;
            try {
                t = this.mCallable.call();
            }
            catch (Exception e) {
                t = null;
            }
            final T result = t;
            final Consumer<T> consumer = this.mConsumer;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    consumer.accept(result);
                }
            });
        }
    }

    private static class HandlerExecutor
    implements Executor {
        private final Handler mHandler;

        HandlerExecutor(@NonNull Handler handler) {
            this.mHandler = Preconditions.checkNotNull(handler);
        }

        @Override
        public void execute(@NonNull Runnable command) {
            if (!this.mHandler.post(Preconditions.checkNotNull(command))) {
                throw new RejectedExecutionException(this.mHandler + " is shutting down");
            }
        }
    }
}

