/*
 * Decompiled with CFR 0.152.
 */
package androidx.vectordrawable.graphics.drawable;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.animation.Interpolator;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.TypedArrayUtils;
import androidx.core.graphics.PathParser;
import androidx.vectordrawable.graphics.drawable.AndroidResources;
import org.xmlpull.v1.XmlPullParser;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class PathInterpolatorCompat
implements Interpolator {
    private static final float PRECISION = 0.002f;
    public static final int MAX_NUM_POINTS = 3000;
    public static final double EPSILON = 1.0E-5;
    private float[] mX;
    private float[] mY;

    public PathInterpolatorCompat(Context context, AttributeSet attrs, XmlPullParser parser) {
        this(context.getResources(), context.getTheme(), attrs, parser);
    }

    public PathInterpolatorCompat(Resources res, Resources.Theme theme, AttributeSet attrs, XmlPullParser parser) {
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_PATH_INTERPOLATOR);
        this.parseInterpolatorFromTypeArray(a, parser);
        a.recycle();
    }

    private void parseInterpolatorFromTypeArray(TypedArray a, XmlPullParser parser) {
        if (TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"pathData")) {
            String pathData = TypedArrayUtils.getNamedString((TypedArray)a, (XmlPullParser)parser, (String)"pathData", (int)4);
            Path path = PathParser.createPathFromPathData((String)pathData);
            if (path == null) {
                throw new InflateException("The path is null, which is created from " + pathData);
            }
            this.initPath(path);
        } else {
            boolean hasY2;
            if (!TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"controlX1")) {
                throw new InflateException("pathInterpolator requires the controlX1 attribute");
            }
            if (!TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"controlY1")) {
                throw new InflateException("pathInterpolator requires the controlY1 attribute");
            }
            float x1 = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"controlX1", (int)0, (float)0.0f);
            float y1 = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"controlY1", (int)1, (float)0.0f);
            boolean hasX2 = TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"controlX2");
            if (hasX2 != (hasY2 = TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"controlY2"))) {
                throw new InflateException("pathInterpolator requires both controlX2 and controlY2 for cubic Beziers.");
            }
            if (!hasX2) {
                this.initQuad(x1, y1);
            } else {
                float x2 = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"controlX2", (int)2, (float)0.0f);
                float y2 = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"controlY2", (int)3, (float)0.0f);
                this.initCubic(x1, y1, x2, y2);
            }
        }
    }

    private void initQuad(float controlX, float controlY) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.quadTo(controlX, controlY, 1.0f, 1.0f);
        this.initPath(path);
    }

    private void initCubic(float x1, float y1, float x2, float y2) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.cubicTo(x1, y1, x2, y2, 1.0f, 1.0f);
        this.initPath(path);
    }

    private void initPath(Path path) {
        PathMeasure pathMeasure = new PathMeasure(path, false);
        float pathLength = pathMeasure.getLength();
        int numPoints = Math.min(3000, (int)(pathLength / 0.002f) + 1);
        if (numPoints <= 0) {
            throw new IllegalArgumentException("The Path has a invalid length " + pathLength);
        }
        this.mX = new float[numPoints];
        this.mY = new float[numPoints];
        float[] position = new float[2];
        for (int i = 0; i < numPoints; ++i) {
            float distance = (float)i * pathLength / (float)(numPoints - 1);
            pathMeasure.getPosTan(distance, position, null);
            this.mX[i] = position[0];
            this.mY[i] = position[1];
        }
        if ((double)Math.abs(this.mX[0]) > 1.0E-5 || (double)Math.abs(this.mY[0]) > 1.0E-5 || (double)Math.abs(this.mX[numPoints - 1] - 1.0f) > 1.0E-5 || (double)Math.abs(this.mY[numPoints - 1] - 1.0f) > 1.0E-5) {
            throw new IllegalArgumentException("The Path must start at (0,0) and end at (1,1) start: " + this.mX[0] + "," + this.mY[0] + " end:" + this.mX[numPoints - 1] + "," + this.mY[numPoints - 1]);
        }
        float prevX = 0.0f;
        int componentIndex = 0;
        for (int i = 0; i < numPoints; ++i) {
            int n = componentIndex++;
            float x = this.mX[n];
            if (x < prevX) {
                throw new IllegalArgumentException("The Path cannot loop back on itself, x :" + x);
            }
            this.mX[i] = x;
            prevX = x;
        }
        if (pathMeasure.nextContour()) {
            throw new IllegalArgumentException("The Path should be continuous, can't have 2+ contours");
        }
    }

    public float getInterpolation(float t) {
        if (t <= 0.0f) {
            return 0.0f;
        }
        if (t >= 1.0f) {
            return 1.0f;
        }
        int startIndex = 0;
        int endIndex = this.mX.length - 1;
        while (endIndex - startIndex > 1) {
            int midIndex = (startIndex + endIndex) / 2;
            if (t < this.mX[midIndex]) {
                endIndex = midIndex;
                continue;
            }
            startIndex = midIndex;
        }
        float xRange = this.mX[endIndex] - this.mX[startIndex];
        if (xRange == 0.0f) {
            return this.mY[startIndex];
        }
        float tInRange = t - this.mX[startIndex];
        float fraction = tInRange / xRange;
        float startY = this.mY[startIndex];
        float endY = this.mY[endIndex];
        return startY + fraction * (endY - startY);
    }
}

