/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.net;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.net.ParseException;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class MailTo {
    public static final String MAILTO_SCHEME = "mailto:";
    private static final String MAILTO = "mailto";
    private static final String TO = "to";
    private static final String BODY = "body";
    private static final String CC = "cc";
    private static final String BCC = "bcc";
    private static final String SUBJECT = "subject";
    private HashMap<String, String> mHeaders = new HashMap();

    private MailTo() {
    }

    public static boolean isMailTo(@Nullable String uri) {
        return uri != null && uri.startsWith(MAILTO_SCHEME);
    }

    public static boolean isMailTo(@Nullable Uri uri) {
        return uri != null && MAILTO.equals(uri.getScheme());
    }

    @NonNull
    public static MailTo parse(@NonNull String uri) throws ParseException {
        String toParameter;
        String query;
        String address;
        int queryIndex;
        Preconditions.checkNotNull(uri);
        if (!MailTo.isMailTo(uri)) {
            throw new ParseException("Not a mailto scheme");
        }
        int fragmentIndex = uri.indexOf(35);
        if (fragmentIndex != -1) {
            uri = uri.substring(0, fragmentIndex);
        }
        if ((queryIndex = uri.indexOf(63)) == -1) {
            address = Uri.decode((String)uri.substring(MAILTO_SCHEME.length()));
            query = null;
        } else {
            address = Uri.decode((String)uri.substring(MAILTO_SCHEME.length(), queryIndex));
            query = uri.substring(queryIndex + 1);
        }
        MailTo mailTo = new MailTo();
        if (query != null) {
            String[] queries;
            for (String queryParameter : queries = query.split("&")) {
                String[] nameValueArray = queryParameter.split("=", 2);
                if (nameValueArray.length == 0) continue;
                String queryParameterKey = Uri.decode((String)nameValueArray[0]).toLowerCase(Locale.ROOT);
                String queryParameterValue = nameValueArray.length > 1 ? Uri.decode((String)nameValueArray[1]) : null;
                mailTo.mHeaders.put(queryParameterKey, queryParameterValue);
            }
        }
        if ((toParameter = mailTo.getTo()) != null) {
            address = address + ", " + toParameter;
        }
        mailTo.mHeaders.put(TO, address);
        return mailTo;
    }

    @NonNull
    public static MailTo parse(@NonNull Uri uri) throws ParseException {
        return MailTo.parse(uri.toString());
    }

    @Nullable
    public String getTo() {
        return this.mHeaders.get(TO);
    }

    @Nullable
    public String getCc() {
        return this.mHeaders.get(CC);
    }

    @Nullable
    public String getBcc() {
        return this.mHeaders.get(BCC);
    }

    @Nullable
    public String getSubject() {
        return this.mHeaders.get(SUBJECT);
    }

    @Nullable
    public String getBody() {
        return this.mHeaders.get(BODY);
    }

    @Nullable
    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder(MAILTO_SCHEME);
        sb.append('?');
        for (Map.Entry<String, String> header : this.mHeaders.entrySet()) {
            sb.append(Uri.encode((String)header.getKey()));
            sb.append('=');
            sb.append(Uri.encode((String)header.getValue()));
            sb.append('&');
        }
        return sb.toString();
    }
}

