#!/usr/bin/perl -w
#
# Przykad dla podrozdziau "Operowanie na tekcie".
# Dodaje 'use strict' do wszystkich skryptw Perla, ktre nie zawieraj
# tej dyrektywy. Zakadamy, e dyrektywa powinna znajdowa si na pocztku
# (nie liczc komentarzy).
#
# Skrypt otrzymuje na wejciu katalog i przeszukuje tylko pliki .pl.

use strict;

#START:body
my $dir = shift or die "Nie podano katalogu";

for my $file (glob("$dir/*.pl")) {

  open(IP, "$file") or die "Otwieranie pliku $file: $!";
  undef $/;           # Wycza separator rekordw w danych wejciowych;
  my $content = <IP>; # odczytuje cay plik jako jeden acuch.
  close(IP);

  if ($content !~ /^use strict/m) {

    rename $file, "$file.bak" or die "Zmiana nazwy pliku $file: $!";
    open(OP, ">$file") or die "Tworzenie pliku $file: $!";
    
    # Umieszcza dyrektyw 'use strict' w pierwszym wierszy, ktry
    # nie rozpoczyna si od znaku '#'.
    $content =~ s/^(?!#)/\nuse strict;\n\n/m;

    print OP $content;
    close(OP);

    print "Zaktualizowano plik $file\n";
  }
  else {
    print "Plik $file zawiera ju dyrektyw\n";
  }
}
#END:body
