#!/usr/bin/perl -w
use strict;

# Przykad dla podrozdziau "Generatory kodu".
# sposb uycia:  cg_base <jzyk> <plik>
#  gdzie <jzyk> identyfikuje generator pliku nazwany
#  <jzyk>_cg.pl

# START:body
my $lang = shift or die "Nie podano jzyka";
$lang .= "_cg.pm";

require "$lang" or die "Nie mona zaadowa $lang";

# Odczytuje i przetwarza plik

my $name;

while (<>) {
  chomp;
  if    (/^\s*$/)     { CG::blankLine(); }
  elsif (/^\#(.*)/)   { CG::comment($1); }
  elsif (/^M\s*(.+)/) { CG::startMsg($1); $name = $1; }
  elsif (/^E/)        { CG::endMsg($name); }
  elsif (/^F\s*(\w+)\s+(\w+)$/)
                      { CG::simpleType($1,$2); }
  elsif (/^F\s*(\w+)\s+(\w+)\[(\d+)\]$/)
                      { CG::arrayType($1,$2,$3); }
  else {
    die "Nieprawidowy wiersz: $_";
  }
}
# END:body


