package dbc;

/**
  * Przykad dla podrozdziau "Projektowanie kontraktowe".
  * Prosta klasa Node dla przykadu listy DBC.
  */

public class Node {

  /**********************************************************************/
  /* Prywatne                                                           */
  /**********************************************************************/
  private Node myPrevious;
  private Node myNext;
  private String myValue;

  /**********************************************************************/
  /* Metody klasy                                                       */
  /**********************************************************************/

  /**********************************************************************/
  /* Tworzenie                                                          */
  /**********************************************************************/

  /**
    * Konstruktor.
    * @param aValue Warto typu String do zapisania.
    */

  public Node (String aValue) {
    myValue = aValue;
  }

  /**********************************************************************/
  /* Polecenie                                                          */
  /**********************************************************************/

  /**
    * Ustawia poprzedni obiekt <code>Node</code>.
    */
  public void setPrev(Node aNode) {
    myPrevious = aNode;
  }

  /**
    * Ustawia nastpny obiekt <code>Node</code>.
    */
  public void setNext(Node aNode) {
    myNext = aNode;
  }

  /**********************************************************************/
  /* Zapytania                                                          */
  /**********************************************************************/

  /**
    * Uzyskuje warto tego obiektu <code>Node</code>.
    */
  public String value() {
    return myValue;
  }

  /**
    * Uzyskuje nastpny obiekt <code>Node</code>.
    */
  public Node next() {
    return myNext;
  }

  /**
    * Uzyskuje poprzedni obiekt <code>Node</code>.
    */
  public Node prev() {
    return myPrevious;
  }

  /** 
    * Zwraca acuchow reprezentacj tego obiektu.
    */
  public String toString() {
    StringBuffer ret = new StringBuffer();
    ret.append("(" + myPrevious.myValue + ")-> ");
    ret.append(myValue);
    ret.append(" ->(" + myNext.myValue + ")");
    return ret.toString();
  }

} // Koniec klasy Node

