package com.pragprog.util;

import java.io.*;
import java.util.Enumeration;
import java.util.Vector;
import java.util.StringTokenizer;
import java.awt.*;
import java.awt.event.*;
import com.pragprog.util.Assert;

/**
  * Plik zawiera wiele prostych przykadw kodu Javy, ktrego nie ma
  * sensu umieszcza w osobnych klasach.
  */

public class Misc {

  FileInputStream ipstream;

  //START:openpasswd
  public void open_passwd() throws FileNotFoundException {

    // Moe zgosi wyjtek FileNotFoundException...
    ipstream = new FileInputStream("/etc/passwd");
    
    // ...
  }
  //END:openpasswd

  //START:openuserfile
  public boolean open_user_file(String name) 
    throws FileNotFoundException {
    
    File f = new File(name);
    
    if (!f.exists()) {
      return false;
    }
    
    ipstream = new FileInputStream(f);
    return true;
  }
  //END:openuserfile

  public static void loopinv() {
    int arr[] = new int[10];

    //START:loopinv
    int m = arr[0];   // zakadamy, e arr.length > 0
    int i = 1;
    
    // Niezmiennik ptli: m = max(arr[0:i-1])
    while (i < arr.length) {
      m = Math.max(m, arr[i]);
      i = i + 1;
    }
    //END:loopinv
  }

  //START:debug
  public static void debug(String s) throws IOException {
    FileWriter fw = new FileWriter("debug.log", true);
    fw.write(s);
    fw.flush();
    fw.close();
  }
  //END:debug

  public void testListener() {
    //START:listen
    Button b = new Button("Przykad");
    b.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        System.err.println ("Nacinito przycisk");
      }
    });
    //END:listen
  }

  public void testStringTokenizer() {
    // START:stringtok
    StringTokenizer st1 = new StringTokenizer("to jest test");
    StringTokenizer st2 = new StringTokenizer("ten test bdzie dziaa");

    while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
      System.out.println(st1.nextToken());
      System.out.println(st2.nextToken());
    }
    // END:stringtok
  }

  //
  // Z podrozdziau "Izolacja i prawo Demeter".
  //

  // 
  // Kilka przypadkowych definicji na potrzeby kompilacji przykadw...
  //
  public class Money {
    public String printFormat() { return "$0.00"; }
  }

  public class BankAccount {
    public void printBalance() {};
    public Money getBalance() {
      return null;
    }
  }

  public void printToScreen(String s) {};

  // START:showbalance
  public void showBalance(BankAccount acct) {
    Money amt = acct.getBalance();
    printToScreen(amt.printFormat());
  }
  // END:showbalance

  public class Other {
  // START:showbalance2
  void showBalance(BankAccount b) {
    b.printBalance();
  }
  // END:showbalance2
  }

  //
  // Definicje dla przykadu pi?a colada.
  //
  public class Blender {
    public void addIngredients(Enumeration e) {};
  }

  // START:colada
  public class Colada {
    private Blender myBlender;
    private Vector myStuff;

    public Colada() {
      myBlender = new Blender();
      myStuff = new Vector();
    }
    private void doSomething() {
      myBlender.addIngredients(myStuff.elements());
    }
  }
  // END:colada

  //
  // Test.
  //
  public final static void main(String args[]) {
    try {
      debug("acuch testowy\n");
    } catch (Exception e) {
      System.out.println("Przechwycono wyjtek: " + e.getMessage());
    }
  }
}

