/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
package dbc;

/**
  * Z podrozdziału „Projektowanie według kontraktu”,
  * Prosty węzeł dla przykładu listy dbc.
  */

public class Node {

  /**********************************************************************/
  /* Składowe prywatne                                        */
  /**********************************************************************/
  private Node myPrevious;
  private Node myNext;
  private String myValue;

  /**********************************************************************/
  /* Metody klasy                                                        */
  /**********************************************************************/

  /**********************************************************************/
  /* Tworzenie                                                        */
  /**********************************************************************/

  /**
    * Konstruktor.
    * @param aValue – wartość tekstowa do zapisania.
    */

  public Node (String aValue) {
    myValue = aValue;
  }

  /**********************************************************************/
  /* Polecenie                                                           */
  /**********************************************************************/

  /**
    * Ustaw poprzedni <code>Węzeł</code>.
    */
  public void setPrev(Node aNode) {
    myPrevious = aNode;
  }

  /**
    * Ustaw następny <code>Węzeł</code>.
    */
  public void setNext(Node aNode) {
    myNext = aNode;
  }

  /**********************************************************************/
  /* Zapytania                                                    */
  /**********************************************************************/

  /**
    * Pobierz wartość tego <code>Węzła</code>.
    */
  public String value() {
    return myValue;
  }

  /**
    * Pobierz następny <code>Węzeł</code>.
    */
  public Node next() {
    return myNext;
  }

  /**
    * Pobierz poprzedni <code>Węzeł</code>.
    */
  public Node prev() {
    return myPrevious;
  }

  /** 
    * Zwraca tekstową reprezentację tego obiektu.
    */
  public String toString() {
    StringBuffer ret = new StringBuffer();
    ret.append("(" + myPrevious.myValue + ")-> ");
    ret.append(myValue);
    ret.append(" ->(" + myNext.myValue + ")");
    return ret.toString();
  }

} // Koniec klasy Node

