/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
package com.pragprog.sample;

/**
  * Z podrozdziału „Refaktoryzacja” zrefaktoryzowana wersja
  * kodu.
  */
public abstract class Shape1 {
  public class Shape {
    
    private double size;
    
    public Shape(double size) {
      this.size = size;
    }
    
    public double getSize() { return size; }

    public abstract double area();
  }
  
  public class Square extends Shape {
    public Square(double size) {
      super(size);
    }
    
    public double area() {
      double size = getSize();
      return size*size;
    }
  }
  
  public class Circle extends Shape {
    public Circle(double size) {
      super(size);
    }
    
    public double area() {
      double size = getSize();
      return Math.PI*size*size/4.0;
    }
  }
}


