/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/

const { start, dispatch, stop, spawn, spawnStateless } = require('nact');

const router = (module, state, msg, context) => {
  let action = module[msg.type];
  if (action && typeof (action) == "function") {
    const nextState = action(msg, context, state);
    return nextState !== undefined ? nextState : state;
  }
  else {
    console.log(`${context.name} customer ignores unknown message:`, msg);
    return state;
  }
}

const start_actor = (actors, name, module, initial_state={}) => {
    return spawn(actors,
                 (state, msg, context) => {
                   return router(module, state, msg, context)
                 },
                 name,
                 { initialState: initial_state }
    );
}


const sleep = (milliseconds) => {
  return new Promise(resolve => setTimeout(resolve, milliseconds))
}

////////////////////////////////////////////////////////////////////////////////////////

const pieCaseActor = {
  'weź kawałek': (msg, context, state) => {
    if (state.slices.length == 0) {
      dispatch(msg.waiter,
               { type: 'error', msg: "nie ma już ciasta", customer: msg.customer })
      return state
    }
    else {
      var slice = state.slices.shift() + " ciasto";
      dispatch(msg.customer,
               { type: 'połóż na stole', food: slice });
      dispatch(msg.waiter,
               { type: 'dodaj do zamówienia', food: slice, customer: msg.customer });
      return state;
    }
  }
}

const waiterActor = {
  "zamówienie": (msg, ctx, state) => {
    if (msg.wants == "ciasto") {
      dispatch(state.pieCase,
               { type: "weź kawałek", customer: msg.customer, waiter: ctx.self })
    }
    else {
      console.dir(`Don't know how to order ${msg.wants}`);
    }
  },

  "dodaj do zamówienia": (msg, ctx) =>
    console.log(`Kelner dodaje ${msg.food} do zamówienia ${msg.customer.name}`),

  "error": (msg, ctx) => {
    dispatch(msg.customer, { type: 'nie ma już ciasta', msg: msg.msg });
    console.log(`\nKelner przeprasza ${msg.customer.name}: ${msg.msg}`)
  }

};

const customerActor = {
  'ochota na ciasto': (msg, ctx, state) => {
    return dispatch(state.waiter,
                    { type: "zamówienie", customer: ctx.self, wants: 'ciasto' })
  },

  'połóż na stole': (msg, ctx, _state) =>
    console.log(`${ctx.self.name} widzi "${msg.food}" umieszczone na stole`),

  'nie ma już ciasta': (_msg, ctx, _state) =>
    console.log(`${ctx.self.name} jest niezadowolony…`)
}

/////////////////////////////////////////////////////////////////////////////////

const actorSystem = start();

let pieCase = start_actor(
  actorSystem,
  'pie-case',
  pieCaseActor,
  { slices: ["jabłkowe", "brzoskwiniowe", "wiśniowe"] });

let waiter = start_actor(
  actorSystem,
  'waiter',
  waiterActor,
  { pieCase: pieCase });

let c1 = start_actor(actorSystem,   'klient1',
                     customerActor, { waiter: waiter });
let c2 = start_actor(actorSystem,   'klient2',
                     customerActor, { waiter: waiter });

dispatch(c1, { type: 'ochota na ciasto', waiter: waiter });
dispatch(c2, { type: 'ochota na ciasto', waiter: waiter });
dispatch(c1, { type: 'ochota na ciasto', waiter: waiter });
dispatch(c2, { type: 'ochota na ciasto', waiter: waiter });
dispatch(c1, { type: 'ochota na ciasto', waiter: waiter });
sleep(500)
  .then(() => {
    stop(actorSystem);
  })
