#!/usr/bin/perl -w
#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---
#
# Z podrozdziału "Operowanie na tekście ",
# dodaje 'use strict' do wszystkich skryptów Perla, gdzie tego brakuje.
# Zakłada, że istniejący rozpoczyna się w kolumnie pierwszej (tak 
# że komentarz powyżej się nie liczy).
#
# Przekaż katalog do przeszukiwania. Uwzględnia tylko pliki .pl

use strict;

my $dir = shift or die "Nie ma takiego katalogu ";

for my $file (glob("$dir/*.pl")) {

  open(IP, "$file") or die "Otwieranie $file: $!";
  undef $/;           # Wyłącz separator rekordu wejściowego --
  my $content = <IP>; # przeczytaj cały plik jako jeden ciąg.
  close(IP);

  if ($content !~ /^use strict/m) {

    rename $file, "$file.bak" or die "Zmiana nazwy $file: $!";
    open(OP, ">$file") or die "Tworzenie $file: $!";
    
    # Umieść 'use strict' w pierwszym wierszu, który
    # nie zaczyna się od '#'
    $content =~ s/^(?!#)/\nuse strict;\n\n/m;

    print OP $content;
    close(OP);

    print "Zaktualizowany $file\n";
  }
  else {
    print "$file już zawiera 'use strict'\n";
  }
}
