/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
package dbc;

/**
  * Z podrozdziału „Projektowanie według kontraktu”. Kod do ćwiczeń.
  */

/**
  * @invariant getSpeed() > 0
  *        implies isFull()              // Nie uruchamiać „na pusto”
  *
  * @invariant getSpeed() >= 0 &&
  *        getSpeed() < 10               //Sprawdzenie zakresu
  */

class dbc_ex {

  private int mySpeed = 0;
  private boolean myIsFull = false;


  /**
    * Zwraca szybkość od 0 (wyłączony) do 10
    */
  public int getSpeed() {
    return mySpeed;
  }

  /**
    * @pre Math.abs(getSpeed() - x) <= 1 // Zmiana tylko o jeden
    * @pre x >= 0 && x < 10             // Sprawdzenie zakresu
    * @post getSpeed() == x              // Uwzględnienie żądanej szybkości
    */
  public void setSpeed(final int x)

  {
    mySpeed = x;
  }


  boolean isFull() {
    return myIsFull;
  }

  /**
    * @pre !isFull()                     // Nie wypełniaj dwa razy
    * @post isFull()                     // Sprawdź, czy operację wykonano
    */
  void fill()

  {
    myIsFull = true;
  }

  /**
    * @pre isFull()                     // Nie opróżniaj dwukrotnie
    * @post !isFull()                    // Sprawdź, czy operację wykonano
    */
  void empty()

  {
    myIsFull = false;
  }

  public static void main(String args[]) {

    // Utworzenie blendera do testów
    dbc_ex blender = new dbc_ex();

    // Testy zgodnie z ciągiem wprowadzonym na standardowym urządzeniu wejściowym
    try {
      int a;
      char c;

      while ((a = System.in.read()) != -1) {

        c = (char)a;

        if (Character.isWhitespace(c)) {
          continue;
        }

        if (Character.isDigit(c)) {
          blender.setSpeed(Character.digit(c, 10));
        }
        else {
          switch (c) {
            case 'F': blender.fill();
                      break;
            case 'E': blender.empty();
                      break;
            case 's': System.out.println("SZYBKOŚĆ: " +
                                         blender.getSpeed());
                      break;
            case 'f': System.out.println("PEŁNY " +
                                         blender.isFull());
                      break;
            default: throw new RuntimeException(
                      "Nieznana dyrektywa testowa");
          }
        }
      }
    }
    catch (java.io.IOException e) {
      System.err.println("Test jig nie powiódł się: " + e.getMessage());
    }

    System.err.println("Blendowanie zakończone \n");
    System.exit(0);

  }

}
