/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
/*************************************************************************
 *   sm1.c		* Sprosta maszyna stanów
 *************************************************************************/ 


#include <ctype.h>
#include <stdio.h>

typedef enum { SPACE, WORD, END } STATE;

int main(int argc, char **argv) {

  STATE state = SPACE;
  int   ch;
  int   count = 0;

  while ((ch = getchar()) != EOF) {

    switch (state) {
      
    case SPACE:
      if (isalpha(ch)) {
	count++;
	state = WORD;
      }
      break;

    case WORD:
      if (!isalpha(ch))
	state = SPACE;
      break;

    default:
      fprintf(stderr, "Nieprawidłowy stan!\n");
    }
  }

  printf("Tekst zawierał %d słówd%s\n", 
	 count, count == 1 ? "" : "s");
}

