/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
/**
  * Parsuje prosty zestaw poleceń grafiki żółwiowej.
  */

#include <stdio.h>
#define ARG    1
#define NO_ARG 0

#define ARRAY_SIZE(A) (sizeof(A)/sizeof(A[0]))

/* Atrapy funkcji obsługi */
void doSelectPen(int cmd, int arg)  { printf("P %d\n", arg); }
void doPenUp(int cmd, int arg)      { printf("U\n"); }
void doPenDown(int cmd, int arg)    { printf("D\n"); }
void doPenDir(int cmd, int arg)     { printf("%c %d\n", cmd, arg); }

/* Ponieważ chcemy, aby język był rozszerzalny, parser będzie sterowany
 * tabelą. Każda pozycja w tabeli zawiera literowe polecenie,
 * flagę, która mówi, czy argument jest wymagany oraz nazwę 
 * procedury wywoływanej w celu obsłużenia tego polecenia.
 */

typedef struct {
  char  cmd;              /* litera polecenia */
  int hasArg;             /* czy pobiera argument */
  void (*func)(int, int); /* procedura do wywołania */
} Command;

static Command cmds[] = {
  { 'P',  ARG,     doSelectPen },
  { 'U',  NO_ARG,  doPenUp },
  { 'D',  NO_ARG,  doPenDown },
  { 'N',  ARG,     doPenDir },
  { 'E',  ARG,     doPenDir },
  { 'S',  ARG,     doPenDir },
  { 'W',  ARG,     doPenDir }
};

/* Funkcja, która wyszukuje polecenie wykonuje liniowe przeszukiwanie  */
/* tabeli i zwraca pasującą pozycję lub polecenie \CF{NULL}. */

Command *findCommand(int cmd) {
  int i;

  for (i = 0; i < ARRAY_SIZE(cmds); i++) {
    if (cmds[i].cmd == cmd)
      return cmds + i;
  }

  fprintf(stderr, "Nieznane polecenie '%c'\n", cmd);
  return 0;
}

/* Czyta argument liczbowy i zwraca TRUE, jeśli zostanie znaleziony */
int getArg(const char *buff, int *result) {
  return sscanf(buff, "%d", result) == 1;
}


/* Główny program jest dość prosty: czytaj wiersz, znajdź polecenie, */
/* pobierz argument jeśli jest obowiązkowy i wywołaj funkcję obsługi. */

int main(int argc, char **argv) {
  char buff[100];

  while (fgets(buff, sizeof(buff), stdin)) {

    Command *cmd = findCommand(*buff);

    if (cmd) {
      int   arg = 0;

      if (cmd->hasArg && !getArg(buff+1, &arg)) {
        fprintf(stderr, "'%c' wymaga argumentu\n", *buff);
        continue;
      }

      cmd->func(*buff, arg);
    }
  }
}
