#!/usr/bin/perl -w
#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---
use strict;

# Z podrozdziału "Języki dziedzinowe ",
# Parsowanie czasu w formacie 
#
#  time -> hh am/pm   |
#          hh:mm      |
#          hh:mm am/pm
#
# wyświetl liczbę minut po północy lub zwróć -1 w przypadku błędu 

$_ = shift;

/^(\d\d?)(am|pm)$/        && doTime($1, 0,  $2, 12);
/^(\d\d?):(\d\d)(am|pm)$/ && doTime($1, $2, $3, 12);
/^(\d\d?):(\d\d)$/        && doTime($1, $2,  0, 24);
die "Invalid time $_\n";

#
# doTime(hour, min, ampm, maxHour)
#
sub doTime($$$$) {
  my ($hour, $min, $offset, $maxHour) = @_;
  die "Invalid hour: $hour" if ($hour >= $maxHour);
  $hour += 12 if ($offset eq "pm");
  print $hour*60 + $min, " minut po północy \n";
  exit(0);
}
