/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
/**
  * Z podrozdziału „Jak zrównoważyć zasoby”, przykład w C++ auto_ptr.
  */

#include <stdio.h>
#include <stl.h>

typedef struct {
  int i;
} Node;

// Włącz nagłówek auto_ptr tutaj, ponieważ w nagłówkach GCC 2.7 ten plik został wykomentowany

template <class X> class auto_ptr {
private:
  X* ptr;
  mutable bool owns;
public:
  typedef X element_type;
  explicit auto_ptr(X* p = 0)  : ptr(p), owns(p) {}
  auto_ptr(const auto_ptr& a)  : ptr(a.ptr), owns(a.owns) {
    a.owns = 0;
  }
  template <class T> auto_ptr(const auto_ptr<T>& a) __STL_NOTHROW
    : ptr(a.ptr), owns(a.owns) {
      a.owns = 0;
  }
 
  auto_ptr& operator=(const auto_ptr& a) __STL_NOTHROW {
    if (&a != this) {
      if (owns)
        delete ptr;
      owns = a.owns;
      ptr = a.ptr;
      a.owns = 0;
    }
  }
  template <class T> auto_ptr& operator=(const auto_ptr<T>& a) __STL_NOTHROW {
    if (&a != this) {
      if (owns)
        delete ptr;
      owns = a.owns;
      ptr = a.ptr;
      a.owns = 0;
    }
  }
  ~auto_ptr() {
    if (owns)
      delete ptr;
  }
 
  X& operator*() const __STL_NOTHROW { return *ptr; }
  X* operator->() const __STL_NOTHROW { return ptr; }
};


void doSomething(void) {
  
  Node *n = new Node;

  try {
    // wykonaj działania
  }
  catch (...) {
    delete n;
    throw;
  }

  delete n;
}

void doSomething1(void) {
  
  Node n;
  n.i = 0;

  try {
    // wykonaj działania
  }
  catch (...) {
    throw;
  }
}

// Wrapper class for Node resources
class NodeResource {
  Node *n;

 public:
  NodeResource() { n = new Node; }
  ~NodeResource() { delete n; }

  Node *operator->() { return n; }
};

void doSomething2(void) {
  
  NodeResource n;

  try {
    // wykonaj działania
  }
  catch (...) {
    throw;
  }
}

void doSomething3(void) {
  auto_ptr<Node> p (new Node);

  // Dostęp do węzła jako p->...
  
  // Węzeł automatycznie usunięty na końcu
}
