﻿using System;

namespace Marketplace.EventSourcing
{
    public static class ValueExtensions
    {
        public static void MustNotBeNull<T>(this Value<T> value) where T : Value<T>
        {
            if (value == null)
                throw new InvalidValueException(typeof(T), "nie może być null");
        }

        public static void MustBe<T>(this Value<T> value) where T : Value<T>
        {
            if (value == null)
                throw new InvalidValueException(typeof(T), "nie może być null");
        }
        
        public static T With<T>(this T instance, Action<T> update)
        {
            update(instance);
            return instance;
        }
    }
}