﻿using System;

namespace Marketplace.Domain.Shared
{
    public static class DomainExceptions
    {
        public class InvalidEntityState : Exception
        {
            public InvalidEntityState(object entity, string message)
                : base($"Zmiana stanu encji {entity.GetType().Name} została odrzucona, {message}")
            {
            }
        }

        public class ProfanityFound : Exception
        {
            public ProfanityFound(string text)
                : base($"Zanaleziono wulgaryzmy w tekście: {text}")
            {
            }
        }
    }
}