<?php 

// Oto prosta strona gwna administracyjnej strony orodka.

require_once ("../config.inc"); // Doczenie pliku konfiguracyjnego.
require_once ("classes/ShoppingCart.class"); // Doczenie klasy.
session_start(); // Rozpoczcie sesji.

$page_title = 'Twj koszyk';
require_once ("includes/public_header.inc"); // Doczenie pliku nagwkowego HTML.

// ***************************************************************
// W tym miejscu rozpoczyna si tre specyficzna dla strony
// ***************************************************************

if (isset ($HTTP_SESSION_VARS['cart'])) { // Jeeli ju rozpoczto sesj(obiekt istnieje)...
	$cart = $HTTP_SESSION_VARS['cart'];
} else {
	$cart = new ShoppingCart();
}

switch ($HTTP_GET_VARS['do']) {

	case "Add":
		$cart->AddItem ($HTTP_GET_VARS[pid]);
		$cart->DisplayCart();
		break;
		
	case "Drop":
		$cart->DropItem ($HTTP_GET_VARS[pid]);
		$cart->DisplayCart();
		break;
		
	case "Change":
		foreach ($HTTP_POST_VARS[pid] as $key => $value) {
			$cart->ChangeQuantity ($key, $value);
		}
		$cart->DisplayCart();
		break;
		
	case "Display":
		$cart->DisplayCart();
		break;
		
	default:
		$cart->DisplayCart();
		break; // To samo co display.

}

session_register ('cart');

// ***************************************************************
// Koniec treci specyficznej dla strony	
// ***************************************************************

require_once ("includes/public_footer.inc"); // Zakoczenie kodu HTML.
?>
