<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
        "http://www.w3.org/TR/2000/REC-xhtml1-20000126/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>Totalizator pikarski</title>
</head>
<body>
<?php 

// Ustawienie numeru tygodnia jako staej.
define ("WEEK", $week);

/* ---------------------------- */
/* Zapis zwycizcw w pliku.    */
/* ---------------------------- */

function write_data ($value, $key, $fp) { // Funkcja write_data zapisuje typy w pliku.

	static $first_line;

	if (!$first_line) { // Zapisanie pierwszego wiersza-atrapy, ale tylko raz.
		fputs ($fp, "Wiersz atrapa\n");
		$first_line = TRUE;
	}

	fputs ($fp, "$value\n"); // Dodanie znaku return, aby kady zapis znalaz si w osobnym wierszu.
}

$file = '2001/picks_' . WEEK . '_Winners_.txt'; // Zidentyfikowanie nazwy pliku w formacie 'picks_1_Winners_.txt'.

if ($fp = @fopen ($file, "w")) { // Otwarcie pliku do zapisu.

	array_walk ($winners, 'write_data', $fp); // Wysanie caej tablicy do funkcji write_data.
	fclose ($fp); // Zamknicie pliku.

	echo 'Zapisano zwycizcw!<br></br>';
	
} else { // Wywietlenie bdu, w przypadku, gdyby otwarcie pliku byo niemoliwe.
	echo "Nie mona otworzy pliku $file! Prosz upewni si, e zmienna week ma warto.<br></br>";
}


/* ---------------------------- */
/* Pobranie typw graczy.       */
/* ---------------------------- */

function read_picks ($dp, $directory) { // Czynno t wykonuje funkcja read_picks.

	global $picks;
	
	if ($file_name = readdir ($dp)) { // Sprawdzenie kadego pliku w katalogu.
	
		if (substr($file_name, 0, 6) == "picks_") { // Kontynuacja, w przypadku odnalezienia pliku z typami.

			$parse_file_name = explode ("_", $file_name); // Przeksztacenie nazwy pliku na odpowiedni format.

			if (($parse_file_name[1] == WEEK) and ($parse_file_name[2] != "Winners")) { // Jeeli to nie jest plik z danymi o zwycizcach, a numer tygodnia jest waciwy...

				$username = $parse_file_name[2];
				$the_file = $directory . $file_name;
				$users_picks = file ($the_file);
				$picks[$username] = $users_picks;	
			}
		}
		
		read_picks ($dp, $directory); // Kolejna iteracja funkcji.
	} 
}

$picks = array(); // Zainicjowanie gwnej zmiennej.

$directory = '2001/';
$dp = opendir ($directory);
read_picks ($dp, $directory);
closedir ($dp);


/* --------------------------------- */
/* Obliczenie tygodniowych wynikw.  */
/* --------------------------------- */

while (list ($key, $value) = each ($picks)) { // Ptla dla wynikw w gwnej tablicy.

	$wins = 0; // Ustawienie na warto 0 dla kadej tablicy.
	$losses = 0; // Ustawienie na warto 0 dla kadej tablicy.

	while (list ($key2, $value2) = each ($value)) { // Ptla dla kadej tablicy uytkownika.

		$value2 = substr ($value2, 0, (strlen($value2) - 2)); // Usunicie znaku return.

		if (($value2 == $winners[$key2]) and ($key2 != 0)) { // Jeeli typ uytkownika jest waciwy, przyznajemy mu punkt, ale nie liczymy wiersza nr 1.
			$wins++;
		} elseif ($key2 != 0 ) {
			$losses++;
		}
	}
	
	$results[$key] = array ('wins' => $wins, 'losses' => $losses); // Zapisanie wynikw kadego z uytkownikw w tablicy.
}

ksort ($results); // Uporzdkowanie tablicy alfabetycznie.


/* ------------------------------- */
/* Zapisanie tygodniowych wynikw. */
/* ------------------------------- */

function write_results ($value, $key, $fp) { // Zapisuje wyniki do pliku.

	static $first_line2;

	if (!$first_line2) { // Zapisanie pierwszego wiersza-atrapy, ale tylko raz.
		fputs ($fp, "Gracz\tpoprawne\tbdne\n"); // Dodanie znaku return tak, aby kady zapis znalaz si w osobnym wierszu.
		$first_line2 = TRUE;
	}

	$data = implode ("\t", $value);
	fputs ($fp, "$key\t$data\n"); // Dodanie znaku return tak, aby kady zapis znalaz si w osobnym wierszu.
}

$file2 = '2001/results_' . WEEK . '_.txt'; // Zidentyfikowanie nazwy pliku w formacie 'results_1_.txt'.

if ($fp2 = @fopen ($file2, "w")) { // Otwarcie pliku do zapisu.

	array_walk ($results, 'write_results', $fp2); // Wysanie zawartoci caej tablicy do funkcji write_results.
	fclose ($fp2); // Zamknicie pliku.
	echo 'Wyniki zapisano.<br></br>';
	
} else { // Wywietlenie komunikatu o bdzie, jeeli otwarcie pliku nie powiodo si.

	echo "Nie mona otworzy pliku z tygodniowymi wynikami, $file2.<br></br>";
}
?>
</body>
</html>