﻿YAHOO.namespace("calendar");

YAHOO.calendar.init = function() {
	YAHOO.calendar.cal1 = new YAHOO.widget.Calendar("cal1Container");
	resetCal();

	document.getElementById("resetCal").onclick = resetCal;
	document.getElementById("getSelectedDate").onclick = showSelected;

	function resetCal() {
		YAHOO.calendar.cal1.cfg.setProperty("pagedate",new Date());
		YAHOO.calendar.cal1.cfg.setProperty("selected","");
		YAHOO.calendar.cal1.render();
	}
}

YAHOO.util.Event.onDOMReady(YAHOO.calendar.init);

function showSelected() {
	var dateString = "Proszę wybrać datę";
	var pickedDate = YAHOO.calendar.cal1.getSelectedDates()[0];
	if (pickedDate) {
		var outDate =  YAHOO.calendar.cal1.Locale.WEEKDAYS_LONG[pickedDate.getDay()] + ", " + YAHOO.calendar.cal1.Locale.MONTHS_LONG[pickedDate.getMonth()] + " " + pickedDate.getDate() + ".";
		dateString = "Oczekujemy na Twój przyjazd dnia " + outDate;
	}
	document.getElementById("datePicked").innerHTML = dateString;
}
