import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import javax.swing.*;

public class Applet7 extends JApplet {
  Date birthday, targetDate;
  Cycle emotional, intellectual, physical;
  Container contentPane;
  JTextField birthdayField, targetDateField;

  public void init() {
    Dimension size=getContentPane().getSize();
    contentPane = new AnimationPane();

    setContentPane(contentPane);
    contentPane.setBackground(Color.white);

    DateFormat fmt = DateFormat.getDateInstance(DateFormat.SHORT, Locale.US);

    String birthdayString = new String("7/22/88");
    try {
      birthday=fmt.parse(birthdayString);
    }
    catch(ParseException e){
      System.out.println(e);
    }
    birthdayField = new JTextField(birthdayString);
    birthdayField.setColumns(7);
    birthdayField.setToolTipText("Podaj dat urodzin. Od niej zaczniemy obliczenia.");
    birthdayField.addActionListener(new MyListener());

    targetDate = new Date();
    targetDateField = new JTextField(fmt.format(targetDate));
    targetDateField.setColumns(7);
    targetDateField.setToolTipText("Podaj dat docelow.");
    targetDateField.addActionListener(new MyListener());

    contentPane.add(birthdayField);
    contentPane.add(targetDateField);

    emotional = new Cycle("Emocjonalny", 28, Color.red);
    intellectual = new Cycle("Intelektualny", 33, Color.blue);
    physical = new Cycle ("Fizyczny", 23, Color.green);
  }

  class Cycle {
    String name;
    int duration;
    Color color;
    JCheckBox checkbox;

    public Cycle(String nameVal, int durationVal, Color colorVal) {
      name = nameVal;
      duration = durationVal;
      color = colorVal;

      checkbox = new JCheckBox(name);
      checkbox.setToolTipText("Wcza/wycza wykres \"" + name + "\".");
      checkbox.setContentAreaFilled(false);
      checkbox.setSelected(true);
      checkbox.addItemListener(new MyListener());
      contentPane.add(this.checkbox);
    }

    public int dayInCycle (Date startDate, Date targetDate) {
      int daysElapsed, cycleDay;
      long milliSecondsElapsed, milliSecondsPerDay;
      milliSecondsPerDay = 1000*60*60*24;
      milliSecondsElapsed = targetDate.getTime() - startDate.getTime();
      daysElapsed = (int)(milliSecondsElapsed/milliSecondsPerDay);
      cycleDay = daysElapsed % duration;
      if (cycleDay==0) cycleDay = duration;
      return cycleDay;
    }
  }

  class MyListener implements ItemListener, ActionListener {
    public void itemStateChanged(ItemEvent e) {
      contentPane.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
      DateFormat fmt = DateFormat.getDateInstance(DateFormat.SHORT, Locale.US);
      try {
        birthday=fmt.parse(birthdayField.getText());
        targetDate=fmt.parse(targetDateField.getText());
      }
      catch(ParseException ex){
        System.out.println(ex);
      }
      contentPane.repaint();
    }
  }

  class AnimationPane extends JPanel {
    private void paintCycle(Graphics g, Cycle currentCycle, int labelHeight) {
      int x, y, oldy, oldx;
      oldy = 0;
      oldx = 0;
      x = 0;
      y = 0;

      GregorianCalendar startCalendar, targetCalendar;
      targetCalendar = new GregorianCalendar();
      targetCalendar.setTime(targetDate);
      startCalendar = new GregorianCalendar();
      startCalendar.setTime(birthday);

      int day;
      int dayInCycle;
      int daysToPaint = 31;

      g.setColor(currentCycle.color);
      g.drawString(currentCycle.name, 10, labelHeight);

      Font myFont = new Font("San-Serif", Font.PLAIN, 9);
      g.setFont(myFont);
      int halfY = getContentPane().getSize().height/2;

      for (day = 1; (day < daysToPaint); day++) {
        x = day*16;
        dayInCycle = currentCycle.dayInCycle(startCalendar.getTime(), targetCalendar.getTime());
        y = (int)((Math.sin(2 * Math.PI * dayInCycle/currentCycle.duration) * 200 ) + halfY);
        y = getContentPane().getSize().height - y;
        if (x > 16) {
          g.drawLine(oldx, oldy, x, y);
          if (day%3==0) {
            g.setColor(Color.black);
            g.drawString(""+(targetCalendar.get(Calendar.MONTH)+1)+"/"+targetCalendar.get(Calendar.DAY_OF_MONTH),x,250);
            g.setColor(currentCycle.color);
          }
        }
        oldy = y;
        oldx = x;
        targetCalendar.add(GregorianCalendar.DATE, 1);
      }
    }

    public void paintComponent(Graphics g) {
      super.paintComponent(g);
      g.setColor(Color.black);
      int halfY = getContentPane().getSize().height/2;
      g.drawLine(0, halfY, getContentPane().getSize().width, halfY);
      if (emotional.checkbox.isSelected()) {
        paintCycle(g, emotional, 10);
      }
      if (intellectual.checkbox.isSelected()) {
        paintCycle(g, intellectual, 20);
      }
      if (physical.checkbox.isSelected()) {
        paintCycle(g, physical, 30);
      }
    }
  }
}