import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Applet6 extends JApplet implements Runnable, ActionListener {
  int xPos, yPos;
  ImageIcon butterflyIcon;
  JButton startStop;
  Thread runner;
  boolean isRunning = true;

  public void init() {
    Dimension size=getContentPane().getSize();

    Container contentPane = new AnimationPane();
    setContentPane(contentPane);
    contentPane.setBackground(Color.white);
    contentPane.setSize(size);
    xPos = contentPane.getSize().width/2;
    yPos = contentPane.getSize().height/2;

    butterflyIcon = new ImageIcon(getImage(getCodeBase(), "butterfly.gif"));

    startStop = new JButton("Stop");
    contentPane.add(startStop);
    startStop.addActionListener(this);
  }

  public void start() {
    if (runner == null) {
      runner = new Thread(this);
      runner.start();
    }
  }

  public void stop() {
    runner = null;
  }

  public void run() {
    while (isRunning) {
      try {
        Thread.sleep(10);
      }
      catch (InterruptedException e) {
      }

      xPos += changeBy();
      yPos += changeBy();
      repaint();
    }
  }

  int changeBy() {
      double myVal;

      if (java.lang.Math.random() < .5) {
        myVal = java.lang.Math.random() * -10;
      }
      else {
        myVal = java.lang.Math.random() * 10;
      }
      return (int) myVal;
  }

  public void actionPerformed(ActionEvent e) {
    if (isRunning) {
      isRunning = false;
      startStop.setText("Start");
      stop();
    }
    else {
      isRunning = true;
      startStop.setText("Stop");
      start();
    }
  }

  class AnimationPane extends JPanel {
    public void paintComponent(Graphics g) {
      super.paintComponent(g);
      butterflyIcon.paintIcon(this, g, xPos, yPos);
    }
  }
}