import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Applet5 extends JApplet implements ItemListener, ActionListener {
  JCheckBox boldButton, italicButton;
  JLabel textLabel;
  JRadioButton sanSerifButton, serifButton;
  JMenuBar menuBar;
  JMenu fileMenu;
  JMenuItem nativeLookItem, javaLookItem, newTextItem;

  public void init() {
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch (Exception excep) { }

    textLabel = new JLabel("Wpisz tutaj swj tekst");
    textLabel.setToolTipText("To, co wpiszesz, bdzie wywietlone na ekranie");

    Font helloFont=new Font("Serif", 0, 32);
    textLabel.setFont(helloFont);

    boldButton = new JCheckBox("Pogrubienie");
    boldButton.setToolTipText("Wytuszcza tekst.");
    boldButton.setMnemonic('b');
    boldButton.setContentAreaFilled(false);

    italicButton = new JCheckBox("Kursywa");
    italicButton.setToolTipText("Pochyla tekst.");
    italicButton.setMnemonic('i');
    italicButton.setContentAreaFilled(false);

    sanSerifButton = new JRadioButton("Sans Serif");
    sanSerifButton.setToolTipText("Wywietla tekst czcionk Sans Serif");
    sanSerifButton.setMnemonic('a');
    sanSerifButton.setContentAreaFilled(false);

    serifButton = new JRadioButton("Serif");
    serifButton.setToolTipText("Wywietla tekst czcionk Serif");
    serifButton.setMnemonic('s');
    serifButton.setContentAreaFilled(false);
    serifButton.setSelected(true);

    ButtonGroup btnGroup = new ButtonGroup();
    btnGroup.add(sanSerifButton);
    btnGroup.add(serifButton);

    boldButton.addItemListener(this);
    italicButton.addItemListener(this);
    sanSerifButton.addItemListener(this);
    serifButton.addItemListener(this);

    Container contentPane = getContentPane();
    contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
    contentPane.setBackground(java.awt.Color.white);
    contentPane.add(textLabel);
    JPanel checkPanel = new JPanel();
    checkPanel.setBackground(java.awt.Color.white);
    checkPanel.add(italicButton);
    checkPanel.add(boldButton);
    JPanel radioPanel = new JPanel();
    radioPanel.setBackground(java.awt.Color.white);
    radioPanel.add(sanSerifButton);
    radioPanel.add(serifButton);
    contentPane.add(checkPanel);
    contentPane.add(radioPanel);

    menuBar = new JMenuBar();
    setJMenuBar(menuBar);
    fileMenu = new JMenu("Plik");
    fileMenu.setMnemonic('P');
    menuBar.add(fileMenu);
    nativeLookItem = new JRadioButtonMenuItem("Wygld Javy");
    nativeLookItem.addActionListener(this);
    javaLookItem = new JRadioButtonMenuItem("Wygld systemu", true);
    javaLookItem.addActionListener(this);
    newTextItem = new JMenuItem("Nowy tekst...");
    newTextItem.addActionListener(this);

    ButtonGroup lookGroup = new ButtonGroup();
    lookGroup.add(nativeLookItem);
    lookGroup.add(javaLookItem);

    fileMenu.add(nativeLookItem);
    fileMenu.add(javaLookItem);
    fileMenu.addSeparator();
    fileMenu.add(newTextItem);
  }

  public void itemStateChanged(ItemEvent e) {
    int style = 0;
    String typeface = "San-Serif";
    if (boldButton.isSelected()) style += Font.BOLD;
    if (italicButton.isSelected()) style += Font.ITALIC;
    if (serifButton.isSelected()) typeface = "Serif";
    Font helloFont = new Font(typeface, style, 32);
    textLabel.setFont(helloFont);
  }

  public void actionPerformed (ActionEvent e) {
    if (e.getActionCommand()=="Wygld Javy") {
      try {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      }
      catch (Exception excep) { }
      SwingUtilities.updateComponentTreeUI(getRootPane());
    }
    else if (e.getActionCommand()=="Wygld systemu") {
      try {
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
      }
      catch (Exception excep) { }
      SwingUtilities.updateComponentTreeUI(getRootPane());
    }
    else if (e.getActionCommand()=="Nowy tekst...") {
      String inputValue = JOptionPane.showInputDialog("Prosz wpisa nowy tekst do wywietlenia");
      if (inputValue.equals("")) inputValue = "Witamy wiat!";
      textLabel.setText(inputValue);
    }
  }
}
