import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Applet4 extends JApplet implements ItemListener {
  JCheckBox boldButton;
  JCheckBox italicButton;
  JLabel helloLabel;
  JRadioButton sanSerifButton, serifButton;

  public void init() {
    helloLabel = new JLabel("BurmaShave");
    helloLabel.setToolTipText("Helpful tooltip text message goes here");

    Font helloFont = new Font("Serif", 0, 32);
    helloLabel.setFont(helloFont);

    boldButton = new JCheckBox("Pogrubienie");
    boldButton.setToolTipText("Wytuszcza tekst.");
    boldButton.setMnemonic('b');
    boldButton.setContentAreaFilled(false);

    italicButton = new JCheckBox("Kursywa");
    italicButton.setToolTipText("Pochyla tekst.");
    italicButton.setMnemonic('i');
    italicButton.setContentAreaFilled(false);

    sanSerifButton = new JRadioButton("Sans Serif");
    sanSerifButton.setToolTipText("Wywietla tekst czcionk Sans Serif");
    sanSerifButton.setMnemonic('a');
    sanSerifButton.setContentAreaFilled(false);

    serifButton = new JRadioButton("Serif");
    serifButton.setToolTipText("Wywietla tekst czcionk Serif");
    serifButton.setMnemonic('s');
    serifButton.setContentAreaFilled(false);
    serifButton.setSelected(true);

    ButtonGroup btnGroup = new ButtonGroup();
    btnGroup.add(sanSerifButton);
    btnGroup.add(serifButton);

    boldButton.addItemListener(this);
    italicButton.addItemListener(this);
    sanSerifButton.addItemListener(this);
    serifButton.addItemListener(this);

    Container contentPane = getContentPane();
    contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));

    contentPane.setBackground(java.awt.Color.white);
    contentPane.add(helloLabel);

    JPanel checkPanel = new JPanel();
    checkPanel.setBackground(java.awt.Color.white);
    checkPanel.add(italicButton);
    checkPanel.add(boldButton);

    JPanel radioPanel = new JPanel();
    radioPanel.setBackground(java.awt.Color.white);
    radioPanel.add(sanSerifButton);
    radioPanel.add(serifButton);

    contentPane.add(checkPanel);
    contentPane.add(radioPanel);
  }

  public void itemStateChanged(ItemEvent e) {
    int style = 0;
    String typeface="San-Serif";
    if (boldButton.isSelected()) style += Font.BOLD;
    if (italicButton.isSelected()) style += Font.ITALIC;
    if (serifButton.isSelected()) typeface = "Serif";
    Font helloFont = new Font(typeface, style, 32);
    helloLabel.setFont(helloFont);
  }
}