import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class Applet7 extends Applet implements ActionListener, ItemListener {
  TextArea inputField;
  String displayText = "Wpisz tekst do wyswietlenia";
  int fontStyle = Font.PLAIN;
  Button updateButton;

  public void init() {
    setBackground(Color.white);

    add(new Label("Tekst:"));
    inputField = new TextArea("",4,20,TextArea.SCROLLBARS_VERTICAL_ONLY);
    add(inputField);

    add(new Label("Styl czcionki:"));
    Checkbox BoldBox = new Checkbox("Pogrubienie",null,false);
    Checkbox ItalicBox = new Checkbox("Kursywa",null,false);
    BoldBox.addItemListener(this);
    ItalicBox.addItemListener(this);
    add(BoldBox);
    add(ItalicBox);

    updateButton = new Button("Uaktualnij tekst");
    updateButton.addActionListener(this);
    add(updateButton);
  }

  public void actionPerformed(ActionEvent e) {
    displayText=inputField.getText();
    repaint();
  }

  public void paint(Graphics g) {
    g.setFont(new Font("TimesRoman",fontStyle,24));
    g.drawString(displayText,10,150);
  }

  public void itemStateChanged(ItemEvent e) {
    Checkbox boxLabel = (Checkbox) e.getSource();

    if (boxLabel.getLabel() == "Pogrubienie") {
      if (boxLabel.getState()) {
        fontStyle += Font.BOLD;
      }
      else {
        fontStyle -= Font.BOLD;
      }
    }

    if (boxLabel.getLabel() == "Kursywa") {
      if (boxLabel.getState()) {
        fontStyle += Font.ITALIC;
      }
      else {
        fontStyle -= Font.ITALIC;
      }
    }
    repaint();
  }
}