import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

public class Applet8 extends Applet implements ItemListener {
  int liczbaApletu = (int)(java.lang.Math.random() * 3) + 1;
  Font f = new Font("TimesRoman", Font.BOLD, 16);
  CheckboxGroup userCheckbox;
  Checkbox kamienCheckBox, nozyceCheckBox, papierCheckBox;
  boolean pierwszaProba = true;
  String wyborUzytkownika;

  public void init() {
    setBackground(Color.white);

    userCheckbox = new CheckboxGroup();
    kamienCheckBox = new Checkbox("Kamien", userCheckbox, false);
    kamienCheckBox.addItemListener(this);
    add(kamienCheckBox);

    nozyceCheckBox = new Checkbox("Nozyce", userCheckbox, false);
    nozyceCheckBox.addItemListener(this);
    add(nozyceCheckBox);

    papierCheckBox = new Checkbox("Papier", userCheckbox, false);
    papierCheckBox.addItemListener(this);
    add(papierCheckBox);
  }

  public void paint(Graphics g) {
    int liczbaUzytkownika;
    String wyborApletu;

    g.setFont(f);

    if (pierwszaProba) {
      g.drawString("Zagraj ze mn w kamie, noyce i papier!",20,60);
      pierwszaProba = false;
    }
    else {
      switch(liczbaApletu) {
        case 1:
          wyborApletu = "Kamie";
          break;
        case 2:
          wyborApletu = "Noyce";
          break;
        case 3:
          wyborApletu = "Papier";
          break;
        default:
          wyborApletu = "Bd";
      }

      switch (wyborUzytkownika.charAt(0)) {
        case 'K':
          liczbaUzytkownika = 1;
          break;
        case 'N':
          liczbaUzytkownika = 2;
          break;
        case 'P':
          liczbaUzytkownika = 3;
          break;
        default:
          liczbaUzytkownika = 0;
      }

      if (liczbaApletu == liczbaUzytkownika) {
        g.drawString("REMIS - zagrajmy jeszcze raz.", 20, 60);
      }
      else {
        if ((liczbaUzytkownika==1 && liczbaApletu==3) || (liczbaUzytkownika==2 && liczbaApletu==1) || (liczbaUzytkownika==3 && liczbaApletu==2)) {
          g.drawString("Wygraem! Wybraem " + wyborApletu + ".", 20, 60);
        }
        else {
          g.drawString("Wygrae! Wybraem " + wyborApletu + ".", 20, 60);
        }
      }
      g.drawString("Aby zagra ponownie, odwie t stron.", 20, 80);
    }
  }

  public void itemStateChanged(ItemEvent e) {
    if (e.getSource() instanceof Checkbox) {
      wyborUzytkownika = userCheckbox.getSelectedCheckbox().getLabel();
      repaint();
    }
  }
}
