import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class calculator extends Applet implements ActionListener {
  TextField display;
  int saveNum = 0;
  int memNum = 0;
  char op = '=';
  char lastOp = '=';
  boolean newNum = true;

  public void init() {
    setBackground(Color.white);

    display = new TextField("0", 6);
    display.setEditable(false);
    add(display);

    Panel p = new Panel();
    p.setLayout(new GridLayout(5, 4));
    for (int i = 1; i <= 9; i++) {
      Button num=new Button("" + i);
      num.addActionListener(this);
      p.add(num);
      if (i==3) {
        Button plus=new Button("+");
        plus.addActionListener(this);
        p.add(plus);
      }
      if (i==6) {
        Button minus=new Button("-");
        minus.addActionListener(this);
        p.add(minus);
      }
    }
    Button times=new Button("*");
    times.addActionListener(this);
    p.add(times);
    Button percent=new Button("%");
    percent.addActionListener(this);
    p.add(percent);
    Button zero=new Button("0");
    zero.addActionListener(this);
    p.add(zero);
    Button inverse=new Button("");
    inverse.addActionListener(this);
    p.add(inverse);
    Button division=new Button("/");
    division.addActionListener(this);
    p.add(division);
    Button memory=new Button("M");
    memory.addActionListener(this);
    p.add(memory);
    Button remindMemory=new Button("RM");
    remindMemory.addActionListener(this);
    p.add(remindMemory);
    Button clear=new Button("C");
    clear.addActionListener(this);
    p.add(clear);
    Button equals=new Button("=");
    equals.addActionListener(this);
    p.add(equals);
    add(p);
  }

  public void actionPerformed(ActionEvent evt) {
    if (evt.getActionCommand() instanceof String) {
      String s = (String) evt.getActionCommand();
      if (s.charAt(0) >= '0' && s.charAt(0) <= '9') {
        if (newNum)
          display.setText(s);
        else
          display.setText(display.getText() + s);
        newNum = false;
      }
      else {
        if (s.charAt(0) == '-' && newNum) {
          display.setText("-");
          newNum = false;
        }
        else {
          op = s.charAt(0);
          calc(Integer.parseInt(display.getText()));
          newNum = true;
        }
        lastOp = op;
      }
    }
    return;
  }

  public void calc(int n) {
    switch (op) {
      case '+':
      case '-':
      case '*':
      case '/':
      case '%':
        saveNum = n;
        return;
    }

    if (op == '=')
      op = lastOp;

    switch (op) {
      case '+':
        saveNum += n;
        break;
      case '-':
        saveNum -= n;
        break;
      case '*':
        saveNum *= n;
        break;
      case '/':
        saveNum /= n;
        break;
      case '%':
        saveNum %= n;
        break;
      case 'M':
        memNum = n;
        saveNum = n;
        break;
      case 'R':
        saveNum = memNum;
        break;
      case 'C':
        saveNum = 0;
        break;
      case '':
        saveNum = -n;
        break;
    }
    display.setText("" + saveNum);
  }
}