import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Applet3 extends JApplet implements ItemListener {
  JCheckBox boldButton;
  JCheckBox italicButton;
  JLabel helloLabel;

  public void init() {
    helloLabel = new JLabel("Ta przestrze jest do wynajcia");
    helloLabel.setToolTipText("Twoja wiadomo dla wiata");

    Font helloFont = new Font("Serif", 0, 32);
    helloLabel.setFont(helloFont);

    boldButton = new JCheckBox("Pogrubienie");
    boldButton.setToolTipText("Wytuszcza tekst.");
    boldButton.setMnemonic('b');
    boldButton.setContentAreaFilled(false);

    italicButton = new JCheckBox("Kursywa");
    italicButton.setToolTipText("Pochyla tekst.");
    italicButton.setMnemonic('i');
    italicButton.setContentAreaFilled(false);

    boldButton.addItemListener(this);
    italicButton.addItemListener(this);

    Container contentPane = getContentPane();
    contentPane.setLayout(new FlowLayout());
    contentPane.setBackground(java.awt.Color.white);
    contentPane.add(helloLabel, BorderLayout.CENTER);
    contentPane.add(italicButton, BorderLayout.EAST);
    contentPane.add(boldButton, BorderLayout.WEST);
  }

  public void itemStateChanged(ItemEvent e) {
    int style = 0;
    if (boldButton.isSelected()) style += Font.BOLD;
    if (italicButton.isSelected()) style += Font.ITALIC;
    Font helloFont = new Font("Serif", style, 32);
    helloLabel.setFont(helloFont);
  }
}
