/*
  Original Copyright: Sun Microsystems 1997.  All rights reserved.
  Author: Patrick Chan (www.xeo.com)   7/19/96
  Version: 1.1

  Version 2.0 changes copyright Dori Smith 2001.
  Modified to work with java 1.1 and later event model.
*/

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.net.*;

public class XeoMenu extends Applet implements MouseListener, MouseMotionListener {
  // The background image.  This had better not be null.
  Image image;

  // These two fields are used to do double-buffering.
  // The dimensions of bbuf is exactly the dimensions of the applet.
  Image bbuf;
  Graphics bbufG;

  // This field is set to true only when the background image has
  // completely loaded.
  boolean imageDone;

  /* Menu data */
  Rectangle[] hitArea;
  Rectangle[] srcRect;
  Point[] dstPt;
  boolean[] down;
  String[] url;

  /* Submenu data */
  String[][] itemUrl;
  String[][] item;

  // If >= 0, this fields holds the index of the current menu.
  // If -1, no menu is current.
  int curMenu;

  // If >= 0, this fields holds the index of the current menu item.
  // If -1, no menu item is current.
  int curMenuItem;

  // This is an array of rectangles - one rectangle for each menu item.
  // Each rectangle specifies the
  // location (relative to the left-corner of the applet) of a menu item.
  //
  // menuItemRect is null when curMenu is -1.
  // It becomes non-null when curMenu >= 0.
  //
  // Note: it would have been better programming to define classes for
  // the menu and menu items.  However, I decided for this little applet
  // to keep the number of class files to a minimum to minimize the download
  // time.
  Rectangle[] menuItemRect;

  // This is the color to paint "behind" the image.
  Color bgColor;

  // [0] is the text color of a menu item; [1] is the text color of a highlighted
  // menu item.
  Color fgMenuColor[] = new Color[2];

  // This is the background of a menu item; [1] is the background color of a
  // highlighted menu item.
  Color bgMenuColor[] = new Color[2];

  // marginH is the number of pixels on the left and right edges of the menu.
  // marginV is the number of pixels on the top and bottom edges of the menu.
  int marginH, marginV;

  // This is the font used to display the menu item labels.
  Font f;

  // This is the font metrics of 'f'.
  FontMetrics fm;

  public void init() {
    int[] ints;

    // Grab applet parameters.
    image = getImage(getCodeBase(), getParameter("image"));
    marginH = Integer.parseInt(getParameter("marginh"));
    marginV = Integer.parseInt(getParameter("marginv"));

    // Get color parameters.
    ints = parseInt(getParameter("bg-color"), " ");
    bgColor = new Color(ints[0], ints[1], ints[2]);
    ints = parseInt(getParameter("fg-menu-color"), " ");
    fgMenuColor[0] = new Color(ints[0], ints[1], ints[2]);
    ints = parseInt(getParameter("fg-hi-menu-color"), " ");
    fgMenuColor[1] = new Color(ints[0], ints[1], ints[2]);
    ints = parseInt(getParameter("bg-menu-color"), " ");
    bgMenuColor[0] = new Color(ints[0], ints[1], ints[2]);
    ints = parseInt(getParameter("bg-hi-menu-color"), " ");
    bgMenuColor[1] = new Color(ints[0], ints[1], ints[2]);

    // Create back buffer for double-buffering.
    bbuf = createImage(getSize().width, getSize().height);
    bbufG = bbuf.getGraphics();

    // Determine the font from the font-height.
    int fh = Integer.parseInt(getParameter("font-height"));
    int i = fh;
    while (i > 10) {
      f = new Font(getParameter("font"), Font.PLAIN, i);
      fm = getFontMetrics(f);
      if (fm.getHeight() <= fh) {
        break;
      }
      i--;
    }

    // Get the menu parameters.
    for (i=0; ; i++) {
      if (getParameter("menu"+i) == null) {
        hitArea = new Rectangle[i];
        srcRect = new Rectangle[i];
        dstPt = new Point[i];
        url = new String[i];
        down = new boolean[i];
        itemUrl = new String[i][];
        item = new String[i][];

        break;
      }
    }

    for (i=0; i<hitArea.length; i++) {
      String[] fields = parse(getParameter("menu"+i), getParameter("separator"));

      // Get the hit area.
      ints = parseInt(fields[0], " ");
      hitArea[i] = new Rectangle(ints[0], ints[1], ints[2], ints[3]);

      // Get the source image.
      ints = parseInt(fields[1], " ");
      srcRect[i] = new Rectangle(ints[0], ints[1], ints[2], ints[3]);

      // Get the destination point.
      ints = parseInt(fields[2], " ");
      dstPt[i] = new Point(ints[0], ints[1]);
      down[i] = fields[3].equals("d");
      url[i] = fields[4];

      item[i] = new String[(fields.length-5)/2];
      itemUrl[i] = new String[(fields.length-5)/2];
      for (int j=0; j<item [i].length; j++) {
        item[i][j] = fields[j*2+5];
        itemUrl[i][j] = fields[j*2+6];
      }
    }
    addMouseMotionListener(this);
    addMouseListener(this);

  }

  // s is a string containing 'sep' separators.  This method
  // breaks up the string at the separators and returns the resulting
  // strings in an array.  The result may have zero length but is never null.
  String[] parse(String s, String sep) {
    StringTokenizer st = new StringTokenizer(s, sep);
    String result[] = new String[st.countTokens()];

    for (int i=0; i<result.length; i++) {
      result[i] = st.nextToken();
    }
    return result;
  }

  // This method is similar to parse() except that the strings are
  // assumed to be decimal integers.  This method coverts these integer
  // strings into integers and returns them in an array.
  // The result may have zero length but is never null.
  int[] parseInt(String s, String sep) {
    StringTokenizer st = new StringTokenizer(s, sep);
    int[] result = new int[st.countTokens()];

    for (int i=0; i<result.length; i++) {
      result[i] = Integer.parseInt(st.nextToken());
    }
    return result;
  }

  public void paint(Graphics g) {
    imageDone = false;
    update(g);
  }

  public void update(Graphics g) {
    Graphics g2;

    if (!imageDone) {
      imageDone = g.drawImage(image, 0, 0, this);
      return;
    }

    bbufG.setColor(bgColor);
    bbufG.fillRect(0, 0, getSize().width, getSize().height);
    bbufG.drawImage(image, 0, 0, this);

    if (curMenu >= 0) {
      g2 = bbuf.getGraphics();
      // Paint the overlay image
      g2.clipRect(dstPt[curMenu].x, dstPt[curMenu].y, srcRect[curMenu].width, srcRect[curMenu].height);
      g2.drawImage(image, dstPt[curMenu].x-srcRect[curMenu].x, dstPt[curMenu].y-srcRect[curMenu].y, this);
      g2.dispose();

      g2 = bbuf.getGraphics();
      for (int i=0; i<menuItemRect.length; i++) {
        drawMenuItem(g2, i);
      }
      g2.dispose();
    }
    g.drawImage(bbuf, 0, 0, this);
  }

  void drawMenuItem(Graphics g, int i) {
    int x, y, w, height;
    // break the menu item label into lines.
    String[] line = parse(item[curMenu][i], getParameter("newline"));

    int hi = 0;
    if (i == curMenuItem) {
      hi = 1;
      getAppletContext().showStatus(itemUrl[curMenu][i]);
    }
    g.setColor(bgMenuColor[hi]);
    g.fillRect(menuItemRect[i].x, menuItemRect[i].y, menuItemRect[i].width, menuItemRect[i].height);

    // set color for text and box
    g.setColor(fgMenuColor[hi]);

    // draw box around menu item.
    g.drawRect(menuItemRect[i].x, menuItemRect[i].y, menuItemRect[i].width, menuItemRect[i].height);

    // draw label
    g.setFont(f);
    y = menuItemRect[i].y + marginV;
    for (i=0; i<line.length; i++) {
      g.drawString(line[i], menuItemRect[i].x+menuItemRect[i].width-fm.stringWidth(line[i])-marginH, y + fm.getAscent());
      y += fm.getHeight();
    }
  }

  public void mouseExited(MouseEvent evt) {
    curMenuItem = curMenu = -1;
    repaint();
    return;
  }

  public void mouseEntered(MouseEvent evt) {
    return;
  }

  public void mouseClicked(MouseEvent evt) {
    return;
  }

  public void mouseReleased(MouseEvent evt) {
    return;
  }

  public void mousePressed(MouseEvent evt) {
    try {
      String u = null;

      if (curMenuItem >= 0 && itemUrl[curMenu].length > 0) {
        u = itemUrl[curMenu][curMenuItem];
      }
      else
        if (curMenu >= 0) {
          u = url[curMenu];
        }
      if (u != null) {
        URL url = new URL (getDocumentBase(), u);

        if (getParameter("target") != null) {
          getAppletContext().showDocument(url, getParameter("target"));
        }
        else {
          getAppletContext().showDocument(url);
        }
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
    return;
  }

  public void mouseDragged(MouseEvent evt) {
    return;
  }

  public void mouseMoved(MouseEvent evt) {
      int x = evt.getX();
    int y = evt.getY();
    if (curMenu >= 0) {
      int sm = inMenu(menuItemRect, x, y);

      if (curMenuItem != sm) {
        curMenuItem = sm;
        repaint();
      }
      if (sm >= 0) {
        return;
      }
      curMenu = -1;
    }

    int m = inMenu(hitArea, x, y);
    if (m != curMenu) {
      curMenu = m;

      // A new menu is now active so compute menuItemRect.
      if (m >= 0) {
        // Minimum width
        int maxWidth = 50;
        int maxHeight = 0;

        menuItemRect = new Rectangle[item[curMenu].length];
        for (int i=0; i<menuItemRect.length; i++) {
          String[] line = parse(item[curMenu][i], getParameter("newline"));

          for (int j=0; j<line.length; j++) {
            int w = fm.stringWidth(line[j]);
            if (w > maxWidth) {
              maxWidth = w;
            }
          }

          menuItemRect[i] = new Rectangle();
          menuItemRect[i].height = parse(item[curMenu][i], getParameter("newline")).length * fm.getHeight() + 2 * marginV;
          maxHeight += menuItemRect[i].height;
        }

        // Add one extra pixel for the left edge.
        maxWidth +=  2 * marginH + 1;
        if (down[m]) {
          y = Math.max(0, Math.min(getSize().height-maxHeight-1, dstPt[curMenu].y + srcRect[curMenu].height-1));
        }
        else {
          y = Math.max(0, Math.min(getSize().height-maxHeight-1, dstPt[curMenu].y - maxHeight));
        }
        x = dstPt[curMenu].x + srcRect[curMenu].width-maxWidth-1;
        for (int i=0; i<item[curMenu].length; i++) {
          menuItemRect[i].x = x;
          menuItemRect[i].y = y;
          menuItemRect[i].width = maxWidth;
          y += menuItemRect[i].height;
        }
        getAppletContext().showStatus(url[curMenu]);
      }
      repaint();
    }
    return;
  }

  // Returns the index of the rectangle in rs containing x and y.
  // Returns -1 if either rs is null or x and y is not in rs.
  int inMenu(Rectangle[] rs, int x, int y) {
    if (rs != null) {
      for (int i=0; i<rs.length; i++) {
        if (rs[i].contains(x, y)) {
          return i;
        }
      }
    }
    return -1;
  }
}
