import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class PollCounter extends HttpServlet {
  Map names = Collections.synchronizedSortedMap(new TreeMap());
  static int votesTotal = 0;
  File filename = new File("pollresults.bin");

  public void init() throws ServletException {
    if (filename.exists()) {
      try {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));

        synchronized(names) {
          if (names.size()==0) {
            System.out.println("PollCounter: Odczytywanie poprzednich wynikw.");
            names = (Map) in.readObject();
          }
          in.close();

          Iterator namesIter = names.keySet().iterator();
          while (namesIter.hasNext()) {
            String itemName = (String) namesIter.next();
            Integer itemVotes =(Integer) names.get(itemName);
            votesTotal += itemVotes.intValue();
          }
        }
      }
      catch(ClassNotFoundException e) {
        System.out.println(e);
      }
      catch(IOException e) {
        System.out.println(e);
      }
    }
  }

  public void destroy() {
    try {
      System.out.println("PollCounter: Zapisywanie biecych wynikw");
      ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
      out.writeObject(names);
      out.close();
    }
    catch(IOException e) {
      System.out.println(e);
    }
  }

  public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    doGet(request, response);
  }

  public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    if (request.getParameter("results") == null) {
      updateCount(request);
    }
    response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    out.println("<html><head><title>Wyniki ankiety</title></head><body bgcolor='white'>");
    out.println(displayVoteResults(request));
    out.println("</body></html>");
  }

  private void updateCount(HttpServletRequest request) {
    Enumeration paramNames = request.getParameterNames();

    while (paramNames.hasMoreElements()) {
      String paramName = (String) paramNames.nextElement();
      String[] paramValues = request.getParameterValues(paramName);
      for (int i=0; i<paramValues.length; i++) {
        incrVote(paramValues[i]);
      }
    }
  }

  private void incrVote(String voteName) {
    Integer storedValue;

    synchronized(names) {
      if (names.containsKey(voteName)) {
        storedValue = (Integer) names.get(voteName);
        storedValue = new Integer(storedValue.intValue()+1);
        names.put(voteName, storedValue);
      }
      else {
        names.put(voteName, new Integer(1));
      }
      votesTotal++;
    }
  }

  private String displayVoteResults(HttpServletRequest request) {
    String results = "<table cellspacing=10>\n\t<tr><th align='left'>Nazwisko</th>";
    results += "<th align='left'>Liczba gosw</th><th align='left'>Procent wszystkich gosw</th></tr>\n";
    Iterator namesIter = names.keySet().iterator();

    while (namesIter.hasNext()) {
      String itemName = (String) namesIter.next();
      Integer votes = (Integer) names.get(itemName);

      int percent = 100 * votes.intValue() / votesTotal;
      results += "\t<tr><td>" + itemName + "</td><td>" + votes + "</td>";
      results += "<td><img src='/examples/images/lilRed.gif' width='";
      results += percent + "' height='10'> " + percent + "</td></tr>\n";
    }
    results += "</table>\n";
    return results;
  }
}
