import java.awt.*;
import java.applet.*;
import java.awt.image.*;

public class Applet7 extends Applet implements Runnable {
  int cardWidth=43, cardHeight=61, thisPos;
  Image winScratch, playingCards, currImg;
  Graphics gScratch;
  Thread runner;

  public void init() {
    winScratch = createImage(this.getSize().width, this.getSize().height);
    gScratch = winScratch.getGraphics();
    setBackground(Color.white);
    playingCards = getImage(getCodeBase(), "cards.gif");
  }

  public void start() {
    runner = new Thread(this);
    runner.start();
  }

  public void run() {
    int randomCard, cardPos;
    ImageFilter cardFilter;
    ImageProducer cardProducer;

    while (true) {
      try {
        Thread.sleep(2000);
      }
      catch (InterruptedException e) {
      }

      thisPos = (int)(java.lang.Math.random() * 200);
      randomCard = (int)(java.lang.Math.random() * 52);
      cardPos = (randomCard * cardWidth) + 1;
      cardFilter = new CropImageFilter(cardPos, 1, cardWidth, cardHeight);
      cardProducer = new FilteredImageSource(playingCards.getSource(), cardFilter);
      currImg = createImage(cardProducer);
      repaint();
    }
  }

  public void paint(Graphics g) {
    if (currImg != null) {
      gScratch.setColor(this.getBackground());
      gScratch.fillRect(0, 0, this.getSize().width, this.getSize().height);
      gScratch.setColor(Color.black);

      gScratch.drawImage(currImg, thisPos+3, 3, this);
      gScratch.drawRoundRect(thisPos+1, 1, cardWidth+2, cardHeight+2, 5, 5);
      g.drawImage(winScratch, 0, 0, this);
    }
  }

  public final void update(Graphics g) {
    paint(g);
  }
}