import java.awt.*;
import java.applet.*;
import java.awt.image.*;

public class Applet6 extends Applet implements Runnable {
  int cardWidth=43, cardHeight=61, imgCt=50, thisPos;
  Image currImg, thisCard[] = new Image[imgCt], winScratch;
  Graphics gScratch;
  Thread runner;

  public void init() {
    int randomCard, cardPos,i;
    Image playingCards;
    ImageFilter cardFilter;
    ImageProducer cardProducer;
    boolean usedCards[] = new boolean [52];

    winScratch = createImage(this.getSize().width, this.getSize().height);
    gScratch = winScratch.getGraphics();
    setBackground(Color.white);
    playingCards = getImage(getCodeBase(), "cards.gif");

    for (i=0; i<imgCt; i++) {
      randomCard = (int)(java.lang.Math.random() * 52);
      if (usedCards[randomCard]) {
        i--;
      }
      else {
        cardPos = (randomCard * cardWidth) + 1;
        cardFilter = new CropImageFilter(cardPos, 1, cardWidth, cardHeight);
        cardProducer = new FilteredImageSource(playingCards.getSource(), cardFilter);
        thisCard[i] = createImage(cardProducer);
        usedCards[randomCard] = true;
      }
    }
    thisPos = (int)(java.lang.Math.random() * 200);
    currImg = thisCard[0];
  }

  public void start() {
    runner = new Thread(this);
    runner.start();
  }

  public void run() {
    for (int i=1; i<imgCt; i++) {
      try {
        Thread.sleep(2000);
      }
      catch (InterruptedException e) {
      }

      thisPos = (int)(java.lang.Math.random() * 200);
      currImg = thisCard[i];
      repaint();
    }
  }

  public void paint(Graphics g) {
    gScratch.setColor(this.getBackground());
    gScratch.fillRect(0, 0, this.getSize().width, this.getSize().height);
    gScratch.setColor(Color.black);

    gScratch.drawImage(currImg, thisPos+3, 3, this);
    gScratch.drawRoundRect(thisPos+1, 1, cardWidth+2, cardHeight+2, 5, 5);
    g.drawImage(winScratch, 0, 0, this);
  }

  public final void update(Graphics g) {
    paint(g);
  }
}