//***************************************************************************************
//
//  Title:  tinyHScroll, by One Wolf WebArt
//  Author: chris@onewolf.com (Christian Ricci)
//
//  For more information please refer to http://www.onewolf.com/
//
//  See also:  tinyHScroll.txt [docs]
//  
//***************************************************************************************
import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class tinyScroller extends Applet
    implements Runnable {                 // Threaded applet

    int maxLines=100,                     // Integer, Maximum number of lines 
    direction=0,                          // Flag, 0=up, 1=down
    delay=100,                            // Integer, delay - controls scroll speed
    startDelay=0,                         // Integer, start delay - before applet runs
    spacing=12,                           // Integer, spacing between lines
    XPos=5,                               // Integer, X position AKA indent
    maxLine=0,                            // Integer, # of Lines being sent
                                          //   - There is a much better way to do this.
                                          //     As done in scrollerPRO and each of the
                                          //     newer tinyApplets. 
    current,                              // Integer, current (initial) position 
    height;                               // Integer, same as size().height
    boolean fixedbg=false;                // Flag, fixed or scrolling background
    String[] Line = new String[maxLines]; // Lines, to be displayed, maxLines
    Image offImage, bg;                   // Tools for double buffering
    Graphics offGrfx;                     // Tools for double buffering
    Font outFont;                         // Font, output font
    boolean customFont = false;           // Flag, is there a custom outFont?
                                          //   - It would be cleaner to simply trap
                                          //     any exceptions thrown by the setFont.
    Color background, fontColor;          // Colors, background and foreground
    Thread runner;                        // Thread stuff

//***************************************************************************************
//
//  Method:   Init
//  Purpose:  To retrieve and massage parameters from HTML
//
//***************************************************************************************

    public void init() {

//****  Get Attributes                                         **************************

        String bgRed$      = getParameter("BGRED");
        String bgGreen$    = getParameter("BGGREEN");
        String bgBlue$     = getParameter("BGBLUE");
        String fgRed$      = getParameter("FGRED");
        String fgGreen$    = getParameter("FGGREEN");
        String fgBlue$     = getParameter("FGBLUE");
        String spacing$    = getParameter("SPACING");
        String delay$      = getParameter("DELAY");
        String startDelay$ = getParameter("STARTDELAY");
        String XPos$       = getParameter("XPOS");
        String maxLine$    = getParameter("MAXLINE");
        String background$ = getParameter("BACKGROUND");
        String fixedbg$    = getParameter("FIXEDBG");
        String fontName$   = getParameter("FONTNAME");
        String fontSize$   = getParameter("FONTSIZE");
        String direction$  = getParameter("DIRECTION");

//****  Massage Attributes, get/setup lines                    **************************

        for (int x=0; x<maxLines; x++) {
            Line[x] = getParameter("LINE" + Integer.toString(x+1));
        }

        for (int x=0; x<maxLines; x++) {
            if (Line[x] == null) break;
            maxLine++;
        }

//****  Massage Attributes, setup output font                  **************************

        if ((fontSize$ != null) && (fontName$ != null)) {
            int size = Integer.parseInt(fontSize$);
            outFont = new Font(fontName$, Font.PLAIN, size);
            customFont = true;
        }

//****  Massage Attributes, colors and background              **************************

        int Red=255;
        int Green=255; 
        int Blue=255;
        int fRed=0;
        int fGreen=0; 
        int fBlue=0;

        if (bgRed$ != null) Red = Integer.parseInt(bgRed$);
        if (bgGreen$ != null) Green = Integer.parseInt(bgGreen$);
        if (bgBlue$ != null) Blue = Integer.parseInt(bgBlue$);
        if (fgRed$ != null) fRed = Integer.parseInt(fgRed$);
        if (fgGreen$ != null) fGreen = Integer.parseInt(fgGreen$);
        if (fgBlue$ != null) fBlue = Integer.parseInt(fgBlue$);

        fontColor = new Color(fRed, fGreen, fBlue);
        background = new Color(Red, Green, Blue);
        setBackground(background);

        if (background$ != null)
          bg = getImage(getDocumentBase(), background$);

//****  Massage Attributes, performance/appearance stuff       **************************

        if ((fixedbg$ != null) && (fixedbg$.equalsIgnoreCase("Y")))
	  fixedbg = true;

        if (spacing$ != null)
	  spacing = Integer.parseInt(spacing$);
        
        if (delay$ != null)
	  delay = Integer.parseInt(delay$);

        if (startDelay$ != null)
          startDelay = Integer.parseInt(startDelay$);
       
        if (XPos$ != null)
	  XPos = Integer.parseInt(XPos$);
       
        height = size().height;                                              

        if (direction$ != null)
          direction = Integer.parseInt(direction$);

        if (direction == 0) { 
          current = height;
        }
        else {
          current = -(maxLine * spacing);
        }

//****  Prep buffer                                            **************************               

        offImage = createImage(size().width, size().height);
        offGrfx = offImage.getGraphics();

    }

//***************************************************************************************
//
//  Method:   Paint
//  Purpose:  Put the stuff on the screen
//
//***************************************************************************************

    public void paint(Graphics screen) {

        /****     Clear prev image        ****/
          offGrfx.setColor(background);
          offGrfx.fillRect(0,0,size().width, size().height);

        /****      Draw background        ****/
          if (bg != null) {
            if (fixedbg) {
              offGrfx.drawImage(bg, 0, 0, null);   
            } else {
              offGrfx.drawImage(bg, 0, current - height, null);          
            }
          }

        /****      Set custom font        ****/
          offGrfx.setColor(fontColor);
          try { offGrfx.setFont(outFont); }
          catch (NullPointerException e) {}

        /****        Draw lines           ****/
          if (direction == 0) {
              for (int i=0; i<maxLine; i++) 
                  offGrfx.drawString(Line[i],  XPos, current + (i * spacing));
          }
          else {
              for (int i=0; i<maxLine; i++)
                  offGrfx.drawString(Line[i],  XPos, current + ( (maxLine-i) * spacing));
          }

        /****   Flip buffer to screen     ****/
          screen.drawImage(offImage, 0, 0, this);
    }

//***************************************************************************************
//
//  Method:   Update
//  Purpose:  Override standard version of method
//
//***************************************************************************************

    public void update(Graphics screen) {
          paint(screen);
    }

//***************************************************************************************
//
//  Methods:  Start, run and stop
//  Purpose:  Thread methods.  Modify run in conjunction with paint to control 
//            text/content manipulation.
//
//***************************************************************************************

    public void start() {
        if (runner == null) {
            runner = new Thread(this);
            runner.start();
        }
    }

    public void run() {
        repaint();

        try { Thread.sleep(startDelay); }
        catch (InterruptedException e) { }
 
        while (true) {
            repaint();
            if (direction == 0) {
                current--;
                if ((current + (maxLine * spacing)) < 0)
                current = height + spacing;
            }
            else {
                current++;
                if (current > height)
                current = -(maxLine * spacing);
            }
            try { Thread.sleep(delay); }
            catch (InterruptedException e) { }
        }
    }

    public void stop() {
        if (runner != null) {
            runner.stop();
            runner = null;
        }
    }
}
