import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ProductDetailComponent } from './product-detail/product-detail.component';
import { ProductListComponent } from './product-list/product-list.component';
import { productDetailResolver } from './product-detail.resolver';

const routes: Routes = [
  { path: 'products', component: ProductListComponent },
  {
     path: 'products/:id',
     component: ProductDetailComponent,
     resolve: {
        product: productDetailResolver
     }
  },
  { path: '', redirectTo: '/products', pathMatch: 'full' }
];


@NgModule({
   imports: [RouterModule.forRoot(routes)],
   exports: [RouterModule]
})
export class ProductsRoutingModule { }
