import { HttpErrorResponse, HttpStatusCode } from '@angular/common/http';
import { ErrorHandler, Injectable } from '@angular/core';

@Injectable()
export class AppErrorHandler implements ErrorHandler {

  handleError(error: any): void {
    const err = error.rejection || error;

    if (err instanceof HttpErrorResponse) {
      switch(err.status) {
        case 0:
          console.error('Błąd po stronie klienta:', error.error);
          break;
        case HttpStatusCode.InternalServerError:
          console.error('Błąd serwera:', error.error);
          break;
        case HttpStatusCode.BadRequest:
          console.error('Błąd żądania:', error.error);
          break;
        default:
          console.error('Nieznany błąd:', error.error);
      }
    } else {
      console.error('Błąd aplikacji:', err)
    }
  }

}
