#! /bin/sh -
#
# Wyszukuje jeden albo kilka plikow zadanych nazwa albo wzorcem
# w sciezce przeszukiwania okreslonej wskazana zmienna srodowiskowa.
#
# Standardowe wyjscie skryptu bedzie zawierac pelna siezke do pierwszego
# wystapienia kazdego z plikow; w obliczu braku pliku na standardowym wyjsciu
# diagnostycznym zostanie wypisany komunikat "nazwa-pliku: nie znaleziono pliku".
#
# Kod powrotny o wartosci 0 oznacza znalezienie wszystkich plikow, 
# kazda niezerowa wartosc oznacza liczbe plikow ktorych nie udalo sie znalezc
# (z uwzglednieniem ograniczenia wartosci kodu powrotnego do 125).
#
# Stosowanie:
#       pathfind [--all] [--?] [--help] [--version] zmienna wzorzec(wzorce)
#
# Opcja --all wymusza kontynuowanie przeszukiwania we wszystkich katalogach sciezki,
# pomimo odnalezienia pierwszego wystapienia pliku.

IFS='
 	'

OLDPATH="$PATH"

PATH=/bin:/usr/bin
export PATH

error()
{
    echo "$@" 1>&2
    usage_and_exit 1
}

usage()
{
    echo "Stosowanie: $PROGRAM [--all] [--?] [--help] [--version] zmienna wzorzec..."
}

usage_and_exit()
{
    usage
    exit $1
}

version()
{
    echo "$PROGRAM wersja $VERSION"
}

warning()
{
    echo "$@" 1>&2
    EXITCODE=`expr $EXITCODE + 1`
}

all=no
envvar=
EXITCODE=0
PROGRAM=`basename $0`
VERSION=1.0

while test $# -gt 0
do
    ## echo "DIAGNOSTYKA: Arg = $1"
    case $1 in
    --all | --al | --a | -all | -al | -a )
	all=yes
	;;
    --help | --hel | --he | --h | '--?' | -help | -hel | -he | -h | '-?' )
	usage_and_exit 0
	;;
    --version | --versio | --versi | --vers | --ver | --ve | --v | \
    -version | -versio | -versi | -vers | -ver | -ve | -v )
	version
	exit 0
	;;
    -*)
	error "Nieznana opcja: $1"
	;;
    *)
	break
	;;
    esac
    shift
done

envvar="$1"
test $# -gt 0 && shift

test "x$envvar" = "xPATH" && envvar=OLDPATH

## echo "DIAGNOSTYKA: pliki = [$@]"

dirpath=`eval echo '${'"$envvar"'}' 2>/dev/null | tr : ' ' `

## echo "DIAGNOSTYKA: dirpath = [$dirpath]"
## echo "DIAGNOSTYKA: envvar = [$envvar]"

# testy sytuacji wyjatkowych
if test -z "$envvar"
then
    error Brak zmiennej srodowiskowej albo zmienna pusta
elif test "x$dirpath" = "x$envvar"
then
    error "Nieodpowiednia (uszkodzona) wersja sh: brak rozwiniecia $envvar"
elif test -z "$dirpath"
then
    error Pusta sciezka przeszukania
elif test $# -eq 0
then
    exit 0
fi

for pattern in "$@"
do
    result=
    for dir in $dirpath
    do
	for file in $dir/$pattern
	do
	    if test -f "$file"
	    then
		result="$file"
		echo $result
		test "$all" = "no" && break 2
	    fi
	done
    done
    test -z "$result" && warning "$pattern: nie znaleziono"
done

# Ograniczenie wartosci kodu powrotnego do wymogow konwencji systemu Unix 
test $EXITCODE -gt 125 && EXITCODE=125

exit $EXITCODE
