'Wyszczeglnienie obszarw nazw
' z ktrych bdzie mona uywa 
' nazw klas bez dugich nazw
Imports System
Imports System.Xml
' koniec

Public Interface IDBIdentity
    ReadOnly Property ID() As Integer
    Property Name() As String
    Property Description() As String
    Function Save() As Boolean
    Function Delete() As Boolean
    Function Read() As Boolean
    Sub Dispose()
End Interface
Public MustInherit Class Employee
    Implements IDBIdentity

    Dim intID As Integer
    Dim strName As String
    Protected strPosition As String

    Public ReadOnly Property ID() As Integer Implements IDBIdentity.ID
        Get
            Return intID
        End Get
    End Property

    Public Property Name() As String Implements IDBIdentity.Name
        Get
            Return strName
        End Get
        Set(ByVal Value As String)
            strName = Value
        End Set
    End Property

    Public Property Description() As String Implements IDBIdentity.Description
        Get
            Return ""
        End Get
        Set(ByVal Value As String)

        End Set
    End Property
    Public Function Save() As Boolean Implements IDBIdentity.Save
        Dim oXml As New XmlDocument()
        Dim oRoot As XmlNode
        Dim oEmp As XmlNode
        Dim oSubNode As XmlNode
        Dim oElem As XmlElement
        Dim oIDNodes As XmlNodeList
        Dim oIDNode As XmlNode
        Dim intIDContent As Integer
        Dim boolNewEmp As Boolean
        Dim boolSuccess As Boolean

        If strName.Length = 0 Then
            ' nie mona zapisa pracownika
            ' bez nazwiska
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Employees.xml")
            Catch ex As IO.FileNotFoundException
                oXml.LoadXml("<?xml version='1.0'?><Employees></Employees>")
            End Try

            oRoot = oXml.DocumentElement

            ' Jeeli ID jest ustawiony na -1
            ' znajd najwiksz warto ID
            ' i dodaj do niej 1 aby utworzy nowy ID
            If intID < 1 Then
                intIDContent = 0
                oIDNodes = oRoot.SelectNodes("//ID")
                For Each oIDNode In oIDNodes
                    If intIDContent < CInt(oIDNode.InnerText) Then
                        intIDContent = CInt(oIDNode.InnerText)
                    End If
                Next
                intID = intIDContent + 1
                boolNewEmp = True
            Else
                oIDNode = oRoot.SelectSingleNode("//Employee[ID='" & intID.ToString & "']")
                If oIDNode Is Nothing Then
                    boolNewEmp = True
                Else
                    boolNewEmp = False
                End If
            End If

            If boolNewEmp Then

                oElem = oXml.CreateElement("Employee")
                oEmp = oRoot.AppendChild(oElem)

                PlaceElement(oEmp, "ID", intID.ToString)
                PlaceElement(oEmp, "Name", strName)
                PlaceElement(oEmp, "Position", strPosition)
                WriteExtra(oEmp, True)
            Else
                oSubNode = oIDNode.SelectSingleNode("Name")
                ReplaceElement(oSubNode, strName)
                WriteExtra(oIDNode, False)
            End If

            oXml.Save("C:\Employees.xml")

            boolSuccess = True
        End If

        Return boolSuccess
    End Function
    Public Function Delete() As Boolean Implements IDBIdentity.Delete
        Dim oXml As New XmlDocument()
        Dim oEmp As XmlNode
        Dim boolSuccess As Boolean

        If intID < 1 Then
            ' nie mona skasowa pracownika
            ' niemajcego ID
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Employees.xml")
                boolSuccess = True
            Catch ex As IO.FileNotFoundException
                boolSuccess = False
            End Try
        End If

        If boolSuccess Then
            oEmp = oXml.SelectSingleNode("//Employee[ID='" & intID.ToString & "']")
            If oEmp Is Nothing Then
                boolSuccess = False
            Else
                oEmp.ParentNode.RemoveChild(oEmp)
            End If
        End If

        If boolSuccess Then
            oXml.Save("C:\Employees.xml")
        End If
        Return boolSuccess
    End Function
    Public Function Read() As Boolean Implements IDBIdentity.Read
        Dim oXml As New XmlDocument()
        Dim oName As XmlNode
        Dim oPosition As XmlNode
        Dim boolSuccess As Boolean

        If intID < 1 Then
            ' nie mona odczyta pracownika
            ' niemajcego ID
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Employees.xml")
                boolSuccess = True
            Catch ex As IO.FileNotFoundException
                boolSuccess = False
            End Try
        End If

        If boolSuccess Then
            oName = oXml.SelectSingleNode("//Employee[ID='" & intID.ToString & "']/Name")
            If oName Is Nothing Then
                boolSuccess = False
            Else
                strName = oName.InnerText
                oPosition = oName.SelectSingleNode("../Position")
                strPosition = oPosition.InnerText
                ReadExtra(oName.ParentNode)
            End If
        End If

        Return boolSuccess
    End Function
    Public Sub Dispose() Implements IDBIdentity.Dispose

    End Sub
    Public Function GetPosition(ByVal intID As Integer) As String
        Return strPosition
    End Function
    Protected Overridable Sub WriteExtra(ByVal oNode As XmlNode, ByVal boolNew As Boolean)
        'w tej klasie ta funkcja nic nie robi
    End Sub
    Protected Overridable Sub ReadExtra(ByVal oNode As XmlNode)
        'w tej klasie ta funkcja nic nie robi
    End Sub
    Public Sub New()
        intID = -1
    End Sub
    Public Sub New(ByVal intNewID As Integer)
        intID = intNewID
    End Sub
    Public Sub New(ByVal intNewID As Integer, ByVal strNewName As String)
        intID = intNewID
        strName = strNewName
    End Sub
End Class

Public Class ProductManager
    Inherits Employee

    Public Sub New()
        MyBase.New()
        strPosition = "Product Manager"
    End Sub
    Public Sub New(ByVal intNewID As Integer)
        MyBase.New(intNewID)
        strPosition = "Product Manager"
    End Sub
    Public Sub New(ByVal intNewID As Integer, ByVal strNewName As String)
        MyBase.New(intNewID, strNewName)
        strPosition = "Product Manager"
    End Sub
End Class

Public Class ProjectManager
    Inherits Employee

    Public Sub New()
        MyBase.New()
        strPosition = "Project Manager"
    End Sub
    Public Sub New(ByVal intNewID As Integer)
        MyBase.New(intNewID)
        strPosition = "Project Manager"
    End Sub
    Public Sub New(ByVal intNewID As Integer, ByVal strNewName As String)
        MyBase.New(intNewID, strNewName)
        strPosition = "Project Manager"
    End Sub
End Class

Public Class Resource
    Inherits Employee

    Dim intHoursPerDay As Integer
    Public Property HoursPerDay() As Integer
        Get
            Return intHoursPerDay
        End Get
        Set(ByVal Value As Integer)
            intHoursPerDay = Value
        End Set
    End Property

    Public Sub New(ByVal strJob As String)
        MyBase.New()
        strPosition = strJob
    End Sub
    Public Sub New(ByVal strJob As String, ByVal intNewID As Integer)
        MyBase.New(intNewID)
        strPosition = strJob
    End Sub
    Public Sub New(ByVal strJob As String, ByVal intNewID As Integer, ByVal strNewName As String)
        MyBase.New(intNewID, strNewName)
        strPosition = strJob
    End Sub

    Protected Overrides Sub WriteExtra(ByVal oNode As System.Xml.XmlNode, ByVal boolNew As Boolean)
        If boolNew Then
            PlaceElement(oNode, "HoursPerDay", intHoursPerDay.ToString)
        Else
            Dim oHours As XmlNode
            Dim oPosition As XmlNode

            oHours = oNode.SelectSingleNode("HoursPerDay")
            ReplaceElement(oHours, intHoursPerDay.ToString)
            oPosition = oNode.SelectSingleNode("Position")
            ReplaceElement(oPosition, strPosition)
        End If
    End Sub

    Protected Overrides Sub ReadExtra(ByVal oNode As System.Xml.XmlNode)
        Dim oHours As XmlNode

        oHours = oNode.SelectSingleNode("HoursPerDay")
        intHoursPerDay = CInt(oHours.InnerText)
    End Sub
End Class
Public Class Product
    Implements IDBIdentity

    Dim intID As Integer
    Dim strName As String
    Dim strDescription As String
    Dim intManagerID As Integer
    Dim colProjects As New Collection()

    Public ReadOnly Property ID() As Integer Implements IDBIdentity.ID
        Get
            Return intID
        End Get
    End Property

    Public Property ManagerID() As Integer
        Get
            Return intManagerID
        End Get
        Set(ByVal Value As Integer)
            intManagerID = Value
        End Set
    End Property

    Public Property Name() As String Implements IDBIdentity.Name
        Get
            Return strName
        End Get
        Set(ByVal Value As String)
            strName = Value
        End Set
    End Property

    Public Property Description() As String Implements IDBIdentity.Description
        Get
            Return strDescription
        End Get
        Set(ByVal Value As String)
            strDescription = Value
        End Set
    End Property
    Public Function Save() As Boolean Implements IDBIdentity.Save
        Dim oXml As New XmlDocument()
        Dim oRoot As XmlNode
        Dim oProd As XmlNode
        Dim oSubNode As XmlNode
        Dim oElem As XmlElement
        Dim oIDNodes As XmlNodeList
        Dim oIDNode As XmlNode
        Dim intIDContent As Integer
        Dim boolNewProd As Boolean
        Dim boolSuccess As Boolean

        If strName.Length = 0 Then
            ' nie mona zapisa produktu
            ' bez nazwy
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Products.xml")
            Catch ex As IO.FileNotFoundException
                oXml.LoadXml("<?xml version='1.0'?><Products></Products>")
            End Try

            oRoot = oXml.DocumentElement

            ' Jeeli ID jest ustawiony na -1
            ' znajd najwiksz warto ID
            ' i dodaj do niej 1 aby utworzy nowy ID
            If intID < 1 Then
                intIDContent = 0
                oIDNodes = oRoot.SelectNodes("//ID")
                For Each oIDNode In oIDNodes
                    If intIDContent < CInt(oIDNode.InnerText) Then
                        intIDContent = CInt(oIDNode.InnerText)
                    End If
                Next
                intID = intIDContent + 1
                boolNewProd = True
            Else
                oIDNode = oRoot.SelectSingleNode("//Product[ID='" & intID.ToString & "']")
                If oIDNode Is Nothing Then
                    boolNewProd = True
                Else
                    boolNewProd = False
                End If
            End If

            If boolNewProd Then

                oElem = oXml.CreateElement("Product")
                oProd = oRoot.AppendChild(oElem)

                PlaceElement(oProd, "ID", intID.ToString)
                PlaceElement(oProd, "Name", strName)
                PlaceElement(oProd, "Description", strDescription)
                PlaceElement(oProd, "ManagerID", intManagerID.ToString)
            Else
                oSubNode = oIDNode.SelectSingleNode("Name")
                ReplaceElement(oSubNode, strName)
                oSubNode = oIDNode.SelectSingleNode("Description")
                ReplaceElement(oSubNode, strDescription)
                oSubNode = oIDNode.SelectSingleNode("ManagerID")
                ReplaceElement(oSubNode, intManagerID.ToString)
            End If

            oXml.Save("C:\Products.xml")

            boolSuccess = True
        End If

        Return boolSuccess
    End Function
    Public Function Delete() As Boolean Implements IDBIdentity.Delete
        Dim oXml As New XmlDocument()
        Dim oProd As XmlNode
        Dim boolSuccess As Boolean

        If intID < 1 Then
            ' nie mona skasowa produktu
            ' niemajcego ID
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Products.xml")
                boolSuccess = True
            Catch ex As IO.FileNotFoundException
                boolSuccess = False
            End Try
        End If

        If boolSuccess Then
            oProd = oXml.SelectSingleNode("//Product[ID='" & intID.ToString & "']")
            If oProd Is Nothing Then
                boolSuccess = False
            Else
                oProd.ParentNode.RemoveChild(oProd)
            End If
        End If

        If boolSuccess Then
            oXml.Save("C:\Products.xml")
        End If
        Return boolSuccess
    End Function
    Public Function Read() As Boolean Implements IDBIdentity.Read
        Dim oXml As New XmlDocument()
        Dim oName As XmlNode
        Dim oNextNode As XmlNode
        Dim boolSuccess As Boolean

        If intID < 1 Then
            ' nie mona odczyta produktu
            ' niemajcego ID
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Products.xml")
                boolSuccess = True
            Catch ex As IO.FileNotFoundException
                boolSuccess = False
            End Try
        End If

        If boolSuccess Then
            oName = oXml.SelectSingleNode("//Product[ID='" & intID.ToString & "']/Name")
            If oName Is Nothing Then
                boolSuccess = False
            Else
                strName = oName.InnerText
                oNextNode = oName.SelectSingleNode("../Description")
                strDescription = oNextNode.InnerText
                oNextNode = oName.SelectSingleNode("../ManagerID")
                intManagerID = CInt(oNextNode.InnerText)
            End If
        End If

        Return boolSuccess
    End Function
    Public Sub Dispose() Implements IDBIdentity.Dispose

    End Sub
    Public Sub New()
        intID = -1
    End Sub
    Public Sub New(ByVal intNewID As Integer)
        intID = intNewID
    End Sub
    Public Sub New(ByVal intNewID As Integer, ByVal strNewName As String)
        intID = intNewID
        strName = strNewName
    End Sub
    Public Overloads Function AddProject() As Project
        Dim intCount As Integer

        intCount = colProjects.Count + 1
        colProjects.Add(New Project(intID), intCount.ToString)
        Return colProjects.Item(intCount.ToString)
    End Function
    Public Overloads Function AddProject(ByVal intProjectID As Integer) As Project
        Dim intCount As Integer

        intCount = colProjects.Count + 1
        colProjects.Add(New Project(intID, intProjectID), intCount.ToString)
        Return colProjects.Item(intCount.ToString)

    End Function
    Public Overloads Function AddProject(ByVal intProjectID As Integer, ByVal strName As String) As Project
        Dim intCount As Integer

        intCount = colProjects.Count + 1
        colProjects.Add(New Project(intID, intProjectID, strName), intCount.ToString)
        Return colProjects.Item(intCount.ToString)

    End Function
End Class
Public Class Project
    Implements IDBIdentity

    Dim intID As Integer
    Dim strName As String
    Dim strDescription As String
    Dim intProductID As Integer
    Dim intManagerID As Integer
    Dim dtStartDate As Date
    Dim dtEndDate As Date
    Dim dtEstEndDate As Date
    Dim colItems As New Collection()

    Public Property ManagerID() As Integer
        Get
            Return intManagerID
        End Get
        Set(ByVal Value As Integer)
            intManagerID = Value
        End Set
    End Property

    Public Property StartDate() As Date
        Get
            Return dtStartDate
        End Get
        Set(ByVal Value As Date)
            dtStartDate = Value
        End Set
    End Property

    Public Property EndDate() As Date
        Get
            Return dtEndDate
        End Get
        Set(ByVal Value As Date)
            dtEndDate = Value
        End Set
    End Property

    Public Property EstEndDate() As Date
        Get
            Return dtEstEndDate
        End Get
        Set(ByVal Value As Date)
            dtEstEndDate = Value
        End Set
    End Property

    Public ReadOnly Property ID() As Integer Implements IDBIdentity.ID
        Get
            Return intID
        End Get
    End Property

    Public Property Name() As String Implements IDBIdentity.Name
        Get
            Return strName
        End Get
        Set(ByVal Value As String)
            strName = Value
        End Set
    End Property

    Public Property Description() As String Implements IDBIdentity.Description
        Get
            Return strDescription
        End Get
        Set(ByVal Value As String)
            strDescription = Value
        End Set
    End Property
    Public Function Save() As Boolean Implements IDBIdentity.Save
        Dim oXml As New XmlDocument()
        Dim oRoot As XmlNode
        Dim oProj As XmlNode
        Dim oSubNode As XmlNode
        Dim oElem As XmlElement
        Dim oIDNodes As XmlNodeList
        Dim oIDNode As XmlNode
        Dim intIDContent As Integer
        Dim boolNewProj As Boolean
        Dim boolSuccess As Boolean

        If strName.Length = 0 Then
            ' nie mona zapisa projektu
            ' bez nazwy
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Projects.xml")
            Catch ex As IO.FileNotFoundException
                oXml.LoadXml("<?xml version='1.0'?><Projects></Projects>")
            End Try

            oRoot = oXml.DocumentElement

            ' Jeeli ID jest ustawiony na -1
            ' znajd najwiksz warto ID
            ' i dodaj do niej 1 aby utworzy nowy ID
            If intID < 1 Then
                intIDContent = 0
                oIDNodes = oRoot.SelectNodes("//ID")
                For Each oIDNode In oIDNodes
                    If intIDContent < CInt(oIDNode.InnerText) Then
                        intIDContent = CInt(oIDNode.InnerText)
                    End If
                Next
                intID = intIDContent + 1
                boolNewProj = True
            Else
                oIDNode = oRoot.SelectSingleNode("//Project[ID='" & intID.ToString & "']")
                If oIDNode Is Nothing Then
                    boolNewProj = True
                Else
                    boolNewProj = False
                End If
            End If

            If boolNewProj Then

                oElem = oXml.CreateElement("Project")
                oProj = oRoot.AppendChild(oElem)

                PlaceElement(oProj, "ID", intID.ToString)
                PlaceElement(oProj, "Name", strName)
                PlaceElement(oProj, "Description", strDescription)
                PlaceElement(oProj, "ProductID", intProductID.ToString)
                PlaceElement(oProj, "ManagerID", intManagerID.ToString)
                PlaceElement(oProj, "StartDate", dtStartDate.ToShortDateString)
                PlaceElement(oProj, "EndDate", dtEndDate.ToShortDateString)
                PlaceElement(oProj, "EstEndDate", dtEstEndDate.ToShortDateString)
            Else
                oSubNode = oIDNode.SelectSingleNode("Name")
                ReplaceElement(oSubNode, strName)
                oSubNode = oIDNode.SelectSingleNode("Description")
                ReplaceElement(oSubNode, strDescription)
                oSubNode = oIDNode.SelectSingleNode("ProductID")
                ReplaceElement(oSubNode, intProductID.ToString)
                oSubNode = oIDNode.SelectSingleNode("ManagerID")
                ReplaceElement(oSubNode, intManagerID.ToString)
                oSubNode = oIDNode.SelectSingleNode("StartDate")
                ReplaceElement(oSubNode, dtStartDate.ToShortDateString)
                oSubNode = oIDNode.SelectSingleNode("EndDate")
                ReplaceElement(oSubNode, dtEndDate.ToShortDateString)
                oSubNode = oIDNode.SelectSingleNode("EstEndDate")
                ReplaceElement(oSubNode, dtEstEndDate.ToShortDateString)
            End If

            oXml.Save("C:\Projects.xml")

            boolSuccess = True
        End If

        Return boolSuccess
    End Function
    Public Function Delete() As Boolean Implements IDBIdentity.Delete
        Dim oXml As New XmlDocument()
        Dim oProj As XmlNode
        Dim boolSuccess As Boolean

        If intID < 1 Then
            ' nie mona skasowa projektu
            ' niemajcego ID
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Projects.xml")
                boolSuccess = True
            Catch ex As IO.FileNotFoundException
                boolSuccess = False
            End Try
        End If

        If boolSuccess Then
            oProj = oXml.SelectSingleNode("//Project[ID='" & intID.ToString & "']")
            If oProj Is Nothing Then
                boolSuccess = False
            Else
                oProj.ParentNode.RemoveChild(oProj)
            End If
        End If

        If boolSuccess Then
            oXml.Save("C:\Projects.xml")
        End If
        Return boolSuccess
    End Function
    Public Function Read() As Boolean Implements IDBIdentity.Read
        Dim oXml As New XmlDocument()
        Dim oName As XmlNode
        Dim oNextNode As XmlNode
        Dim boolSuccess As Boolean

        If intID < 1 Then
            ' nie mona odczyta projektu
            ' niemajcego ID
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Projects.xml")
                boolSuccess = True
            Catch ex As IO.FileNotFoundException
                boolSuccess = False
            End Try
        End If

        If boolSuccess Then
            oName = oXml.SelectSingleNode("//Project[ID='" & intID.ToString & "']/Name")
            If oName Is Nothing Then
                boolSuccess = False
            Else
                strName = oName.InnerText
                oNextNode = oName.SelectSingleNode("../Description")
                strDescription = oNextNode.InnerText
                oNextNode = oName.SelectSingleNode("../ProductID")
                intProductID = CInt(oNextNode.InnerText)
                oNextNode = oName.SelectSingleNode("../ManagerID")
                intManagerID = CInt(oNextNode.InnerText)
                oNextNode = oName.SelectSingleNode("../StartDate")
                dtStartDate = oNextNode.InnerText
                oNextNode = oName.SelectSingleNode("../EndDate")
                dtEndDate = oNextNode.InnerText
                oNextNode = oName.SelectSingleNode("../EstEndDate")
                dtEstEndDate = oNextNode.InnerText
            End If
        End If

        Return boolSuccess
    End Function
    Public Sub Dispose() Implements IDBIdentity.Dispose

    End Sub
    Public Sub New(ByVal intProduct As Integer)
        intID = -1
        intProductID = intProduct
    End Sub
    Public Sub New(ByVal intProduct As Integer, ByVal intNewID As Integer)
        intID = intNewID
        intProductID = intProduct
    End Sub
    Public Sub New(ByVal intProduct As Integer, ByVal intNewID As Integer, ByVal strNewName As String)
        intID = intNewID
        strName = strNewName
        intProductID = intProduct
    End Sub
    Public Overloads Function AddItem() As ProjectItems
        Dim intCount As Integer

        intCount = colItems.Count + 1
        colItems.Add(New ProjectItems(intID), intCount.ToString)
        Return colItems.Item(intCount.ToString)
    End Function
    Public Overloads Function AddItem(ByVal intItemID As Integer) As ProjectItems
        Dim intCount As Integer

        intCount = colItems.Count + 1
        colItems.Add(New ProjectItems(intID, intItemID), intCount.ToString)
        Return colItems.Item(intCount.ToString)

    End Function
End Class
Public Class ProjectItems
    Implements IDBIdentity

    Dim intID As Integer
    Dim strDescription As String
    Dim intProjectID As Integer
    Dim intResID As Integer
    Dim dtStartDate As Date
    Dim intHours As Integer

    Public Property ResID() As Integer
        Get
            Return intResID
        End Get
        Set(ByVal Value As Integer)
            intResID = Value
        End Set
    End Property

    Public Property StartDate() As Date
        Get
            Return dtStartDate
        End Get
        Set(ByVal Value As Date)
            dtStartDate = Value
        End Set
    End Property

    Public Property Hours() As Integer
        Get
            Return intHours
        End Get
        Set(ByVal Value As Integer)
            intHours = Value
        End Set
    End Property

    Public Sub New(ByVal intProject As Integer)
        intID = -1
        intProjectID = intProject
    End Sub
    Public Sub New(ByVal intProject As Integer, ByVal intNewID As Integer)
        intID = intNewID
        intProjectID = intProject
    End Sub

    Public ReadOnly Property ID() As Integer Implements IDBIdentity.ID
        Get
            Return intID
        End Get
    End Property

    Public Property Name() As String Implements IDBIdentity.Name
        Get
            Return ""
        End Get
        Set(ByVal Value As String)
            ' nothing
        End Set
    End Property

    Public Property Description() As String Implements IDBIdentity.Description
        Get
            Return strDescription
        End Get
        Set(ByVal Value As String)
            strDescription = Value
        End Set
    End Property
    Public Function Save() As Boolean Implements IDBIdentity.Save
        Dim oXml As New XmlDocument()
        Dim oRoot As XmlNode
        Dim oItem As XmlNode
        Dim oSubNode As XmlNode
        Dim oElem As XmlElement
        Dim oIDNodes As XmlNodeList
        Dim oIDNode As XmlNode
        Dim intIDContent As Integer
        Dim boolNewItem As Boolean
        Dim boolSuccess As Boolean

        If strDescription.Length = 0 Then
            ' nie mona zapisa elementu projektu
            ' bez nazwy
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Items.xml")
            Catch ex As IO.FileNotFoundException
                oXml.LoadXml("<?xml version='1.0'?><Items></Items>")
            End Try

            oRoot = oXml.DocumentElement

            ' Jeeli ID jest ustawiony na -1
            ' znajd najwiksz warto ID
            ' i dodaj do niej 1 aby utworzy nowy ID
            If intID < 1 Then
                intIDContent = 0
                oIDNodes = oRoot.SelectNodes("//ID")
                For Each oIDNode In oIDNodes
                    If intIDContent < CInt(oIDNode.InnerText) Then
                        intIDContent = CInt(oIDNode.InnerText)
                    End If
                Next
                intID = intIDContent + 1
                boolNewItem = True
            Else
                oIDNode = oRoot.SelectSingleNode("//Item[ID='" & intID.ToString & "']")
                If oIDNode Is Nothing Then
                    boolNewItem = True
                Else
                    boolNewItem = False
                End If
            End If

            If boolNewItem Then

                oElem = oXml.CreateElement("Item")
                oItem = oRoot.AppendChild(oElem)

                PlaceElement(oItem, "ID", intID.ToString)
                PlaceElement(oItem, "Description", strDescription)
                PlaceElement(oItem, "ProjectID", intProjectID.ToString)
                PlaceElement(oItem, "ResID", intResID.ToString)
                PlaceElement(oItem, "StartDate", dtStartDate.ToShortDateString)
                PlaceElement(oItem, "Hours", intHours.ToString)
            Else
                oSubNode = oIDNode.SelectSingleNode("Description")
                ReplaceElement(oSubNode, strDescription)
                oSubNode = oIDNode.SelectSingleNode("ProjectID")
                ReplaceElement(oSubNode, intProjectID.ToString)
                oSubNode = oIDNode.SelectSingleNode("ResID")
                ReplaceElement(oSubNode, intResID.ToString)
                oSubNode = oIDNode.SelectSingleNode("StartDate")
                ReplaceElement(oSubNode, dtStartDate.ToShortDateString)
                oSubNode = oIDNode.SelectSingleNode("Hours")
                ReplaceElement(oSubNode, intHours.ToString)
            End If

            oXml.Save("C:\Items.xml")

            boolSuccess = True
        End If

        Return boolSuccess
    End Function
    Public Function Delete() As Boolean Implements IDBIdentity.Delete
        Dim oXml As New XmlDocument()
        Dim oItem As XmlNode
        Dim boolSuccess As Boolean

        If intID < 1 Then
            ' nie mona skasowa elementu projektu
            ' niemajcego ID
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Items.xml")
                boolSuccess = True
            Catch ex As IO.FileNotFoundException
                boolSuccess = False
            End Try
        End If

        If boolSuccess Then
            oItem = oXml.SelectSingleNode("//Item[ID='" & intID.ToString & "']")
            If oItem Is Nothing Then
                boolSuccess = False
            Else
                oItem.ParentNode.RemoveChild(oItem)
            End If
        End If

        If boolSuccess Then
            oXml.Save("C:\Items.xml")
        End If
        Return boolSuccess
    End Function
    Public Function Read() As Boolean Implements IDBIdentity.Read
        Dim oXml As New XmlDocument()
        Dim oDesc As XmlNode
        Dim oNextNode As XmlNode
        Dim boolSuccess As Boolean

        If intID < 1 Then
            ' nie mona odczyta elementu projektu
            ' niemajcego ID
            boolSuccess = False
        Else
            Try
                oXml.Load("C:\Items.xml")
                boolSuccess = True
            Catch ex As IO.FileNotFoundException
                boolSuccess = False
            End Try
        End If

        If boolSuccess Then
            oDesc = oXml.SelectSingleNode("//Item[ID='" & intID.ToString & "']/Description")
            If oDesc Is Nothing Then
                boolSuccess = False
            Else
                strDescription = oDesc.InnerText
                oNextNode = oDesc.SelectSingleNode("../ProjectID")
                intProjectID = CInt(oNextNode.InnerText)
                oNextNode = oDesc.SelectSingleNode("../ResID")
                intResID = CInt(oNextNode.InnerText)
                oNextNode = oDesc.SelectSingleNode("../StartDate")
                dtStartDate = oNextNode.InnerText
                oNextNode = oDesc.SelectSingleNode("../Hours")
                intHours = CInt(oNextNode.InnerText)
            End If
        End If

        Return boolSuccess
    End Function
    Public Sub Dispose() Implements IDBIdentity.Dispose

    End Sub
End Class
