Public Class Books
  Implements IDisposable

    'Prywatne pole do uytku wewntrznego
  Private SqlCommand As SqlClient.SqlDataAdapter
  Private QueryData As BookData
  Private CurrentRow As Int32

    'Publiczny interfejs New() dla konstruktora obiektu
  Public Sub New()
       ...
  End Sub

    'Publiczny interfejs Dispose()
  Public Overridable Sub Dispose() Implements IDisposable.Dispose
       ...
  End Sub

    'Chroniony podprogram Dispose() do wewntrznego uytku klasy 
    Protected Overridable Sub Dispose(ByVal disposing As Boolean)
        If Not disposing Then
            Exit Sub ' zbieranie informacji umoliwiajcych
            'zajmowanie si obiektem przez GC
        End If

        If Not SqlCommand Is Nothing Then
            If Not SqlCommand.SelectCommand Is Nothing Then
                If Not SqlCommand.SelectCommand.Connection Is Nothing Then
                    SqlCommand.SelectCommand.Connection.Dispose()
                End If
                SqlCommand.SelectCommand.Dispose()
            End If
            SqlCommand.Dispose()
            SqlCommand = Nothing
        End If
    End Sub

    'Publiczna metoda Query() umoliwiajca uytkownikowi obiektu 
    'zadanie zapytania o ksik w bazie danych
    Public Sub Query()
      ...
    End Sub

    'Publiczna metoda Fetch() umoliwiajca uytkownikowi obiektu
    'pobieranie pojedyczego rekordu z odpowiedzi na zapytanie.
    'Wynik jest wczytywany do pola dostpnego przez publiczne waciwoci.
    Public Function Fetch() As Boolean
      ...
    End Function

#Region " Property Definitions "

    Private strTitle As String
    Private strAuthor As String
    Private dPrice As Double

    Public ReadOnly Property Title() As String
        Get
            Title = strTitle
        End Get
    End Property

    Public ReadOnly Property Author() As String
        Get
            Author = strAuthor
        End Get
    End Property

    Public ReadOnly Property Price() As String
        Get
            Price = dPrice.ToString("c")
        End Get
    End Property

#End Region

    'Klas BookData dostarcza klas DataSet ktora reprezentuje dane 
    'w odpowiedzi na zapytanie
    <SerializableAttribute()> Private Class BookData
        Inherits DataSet

        Public Const BOOK_TABLE As String = "TitleView"
        Public Const TITLE_COLUMN As String = "title"
        Public Const AUTHOR_COLUMN As String = "au_lname"
        Public Const PRICE_COLUMN As String = "price"

        Public Sub New(ByVal info As SerializationInfo, _
               ByVal context As StreamingContext)
            MyBase.New(info, context)
        End Sub

        Public Sub New()
            MyBase.New()
            BuildDataTables()
        End Sub

        Private Sub BuildDataTables()
            '
            ' Utworzenie tablicy ksiek
            '
            Dim table As DataTable = New DataTable(BOOK_TABLE)

            With table.Columns
                .Add(TITLE_COLUMN, GetType(String))
                .Add(AUTHOR_COLUMN, GetType(String))
                .Add(PRICE_COLUMN, GetType(Double))
            End With

            Me.Tables.Add(table)
        End Sub
    End Class
End Class
