//---------------------------------------------------------------------------
#ifndef obrazH
#define obrazH

#include "skala.h"
#include "geometria.h"

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Definicja elementu zabudowy sceny
class TTrojkat
{
 private:
 public:
    TPunkt p1, p2, p3;          //punkty wyznaczajce trjkt
    TWektor N;                  //wektor normalny
    TTrojkat( TPunkt Ap1, TPunkt Ap2, TPunkt Ap3);
    TTrojkat( const TTrojkat &t);
    TTrojkat & operator= (const TTrojkat &t);
};
//---------------------------------------------------------------------------
//  Definicja promienia
class TPromien
{
 private:
    TPunkt r0;              //punkt zaczepienia
    TWektor kierunek;       //skierowanie, zadane wektorem (unormowanym)
 public:
    TPromien( void);
    TPromien( TPunkt Aa, TPunkt Ab);
    TPromien( TPunkt Aa, TWektor Akierunek);
    TPromien( const TPromien &p);
    TPromien & operator= (const TPromien &);
    bool czy_trafia_w_plaszczyzne( TTrojkat t, TPunkt &p);
    bool czy_trafia_w_trojkat( TTrojkat t, TPunkt &p, TPromien &r);
};
//---------------------------------------------------------------------------
class TObraz : public TSkalowanie
{
 private:
    TPunkt obs;             //pozycja obserwatora
    double R, Rxy;          //odlego obserwatora i jej rzut na paszczyzn XY
    double odl_ekr;         //odlego ekranu od oczu
    double sf, cf, st, ct;  //wspczynniki macierzy obrotu
    TPromien daj_promien( int i, int j);//promien, przechodzcy przez piksel (i, j);
 public:
    TObraz( TPunkt Aobs,    //pozycja obserwatora
            int eszer, int ewys,//pikselowe pole obrazu
            double Aodl_ekr, //odlego pola obrazu
            double szer, double wys);//fizyczne pole obrazu
    TColor kolor_piksela( int i, int j);
    TPunkt daj_punkt( int i, int j);    //testowa
};
//---------------------------------------------------------------------------
//  Funkcja pomocnicza. Maksimum wartoci bezwzgldnych.
inline double max( double a, double b, double c)
{
 double a1 = a < 0 ? -a : a,
        b1 = b < 0 ? -b : b,
        c1 = c < 0 ? -c : c;

 return (a1 > b1 ? (a1 > c1 ? a : c) : (b1 > c1 ? b : c));
}
#endif
