//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "obraz.h"
#include "3d.h"
#include "ftech2.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
 inicjuj_parametry();
}
//---------------------------------------------------------------------------
void TForm1::inicjuj_parametry( void)
{
 double k = M_PI / 180.;
 double R = TrackBar1 -> Position,
        fi = k * TrackBar2 -> Position,
        teta = k * TrackBar3 -> Position, x, y, z;

 x = R * cos( fi) * sin( teta);
 y = R * sin( fi) * sin( teta);
 z = R * cos( teta);

 Pobs = TPunkt( x, y, z);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 inicjuj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 int piksel_szer = 60, piksel_wys = 40;
 TPunkt oko( 10, 10, 10);
 TObraz obraz( oko, piksel_szer, piksel_wys, 3, 3.6, 2.4);
 T3d d( Pobs, 0, 0, PaintBox1 -> Width, PaintBox1 -> Height, 0.3);


 TPunkt p0( 0, 0, 0);               //rodek ukadu XYZ
 TPunkt p1, p2, p3, p4;             //rogi ekranu
 TPunkt p;
 TPunkt pa( -5, -2, -2),            //rogi przykadowego obiektu - trjkta
        pb( -3, -2, -5),
        pc( -2, -5, -3);
 TTrojkat t( pa, pb, pc);           //trjkt
 int i = 50, j = 10;                //przykadowy piksel
 TPromien r( oko, obraz.daj_punkt( i, j)); //przykadowy promie z oka przez wskazany piksel

                                    //rogi ekranu
 p1 = obraz.daj_punkt( 0, 0);
 p2 = obraz.daj_punkt( piksel_szer, 0);
 p3 = obraz.daj_punkt( piksel_szer, piksel_wys);
 p4 = obraz.daj_punkt( 0, piksel_wys);

                                    //ekran
 linia3d( p1, p2, &d, PaintBox1 -> Canvas, clBlue);
 linia3d( p2, p3, &d, PaintBox1 -> Canvas, clBlue);
 linia3d( p3, p4, &d, PaintBox1 -> Canvas, clBlue);
 linia3d( p4, p1, &d, PaintBox1 -> Canvas, clBlue);

 for( int i = 0; i < piksel_szer; i += 2)    //dese ekranu
 {
    for( int j = 0; j < piksel_wys; j += 2)
    {
        p = obraz.daj_punkt( i, j);
        punkt3d( p, &d, PaintBox1 -> Canvas, clSilver);
    }
 }
                                    //trjkt
 linia3d( pa, pb, &d, PaintBox1 -> Canvas, clGreen);
 linia3d( pb, pc, &d, PaintBox1 -> Canvas, clGreen);
 linia3d( pc, pa, &d, PaintBox1 -> Canvas, clGreen);

                                    //Ukad odniesienia
 linia3d( p0, TPunkt( 10, 0, 0), &d, PaintBox1 -> Canvas, clSilver);
 linia3d( p0, TPunkt( 0, 10, 0), &d, PaintBox1 -> Canvas, clSilver);
 linia3d( p0, TPunkt( 0, 0, 10), &d, PaintBox1 -> Canvas, clSilver);

                                    //Graniastosup widzenia
 linia3d( oko, p1, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( oko, p2, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( oko, p3, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( oko, p4, &d, PaintBox1 -> Canvas, clSilver);

                                    //o gwna
 linia3d( oko, p0, &d, PaintBox1 -> Canvas, clSilver);

                                    //przykadowy promie
 if( r.czy_trafia_w_plaszczyzne( t, p))
 {
    linia3d( oko, p, &d, PaintBox1 -> Canvas, clRed);
 }
}
//---------------------------------------------------------------------------
//  Wywietlenie punktu. Pomocnicze.
void TForm1 :: punkt3d( TPunkt p, T3d *d, TCanvas *cnv, TColor kolor)
{
 int xe, ye;
 d -> punkt_3d( xe, ye, p);
 cnv -> Pixels[ xe][ ye] = kolor;
}
//---------------------------------------------------------------------------
//  Wywietlenie linii czcej 2 punkty. Pomocnicze.
void TForm1 :: linia3d( TPunkt p1, TPunkt p2, T3d *d, TCanvas *cnv, TColor kolor)
{
 int xe, ye;
 cnv -> Pen -> Color = kolor;
 d -> punkt_3d( xe, ye, p1);
 cnv -> MoveTo( xe, ye);
 d -> punkt_3d( xe, ye, p2);
 cnv -> LineTo( xe, ye);
}
//---------------------------------------------------------------------------

