//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "obraz.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
//  Konstruktor podstawowy
TTrojkat :: TTrojkat( TPunkt Aa, TPunkt Ab, TPunkt Ac)
{
 a = Aa;
 b = Ab;
 c = Ac;
}
//---------------------------------------------------------------------------
//  Konstruktor kopiujcy
TTrojkat :: TTrojkat( const TTrojkat &t)
{
 a = t.a;
 b = t.b;
 c = t.c;
}
//---------------------------------------------------------------------------
//  Operator przypisania
TTrojkat & TTrojkat :: operator= (const TTrojkat &t)
{
 if( this != &t)
 {
    a = t.a;
    b = t.b;
    c = t.c;
 }
 return *this;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Konstruktor podstawowy. Promien z punktu Ar0, skierowany w Akierunek
TPromien :: TPromien( TPunkt Ar0, TWektor Akierunek)
{
 r0 = Ar0;
 kierunek = Akierunek;
}
//---------------------------------------------------------------------------
//  Inny konstruktor. Promien skierowany od a do b.
TPromien :: TPromien( TPunkt Aa, TPunkt Ab)
{
 r0 = Aa;
 kierunek = TWektor( Ab.x - Aa.x, Ab.y - Aa.y, Ab.z - Aa.z);
 kierunek.unormuj();
}
//---------------------------------------------------------------------------
//  Konstruktor kopiujcy
TPromien :: TPromien( const TPromien &p)
{
 r0 = p.r0;
 kierunek = p.kierunek;
}
//---------------------------------------------------------------------------
//  Operator przypisania
TPromien & TPromien :: operator= (const TPromien &p)
{
 if( this != &p)
 {
    r0 = p.r0;
    kierunek = p.kierunek;
 }
 return *this;
}
//---------------------------------------------------------------------------
//  Szukanie przecicia promienia z trjktem zabudowy sceny.
//  Parametry referencyjne s wypeniane, o ile przecicie istnieje.
bool TPromien :: czy_trafia( TTrojkat t, TPunkt &trafienie, TPromien &odbicie)
{
 bool ret = true;
                                //szybki test cieniowy


 return ret;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Konstruktor merytoryczny. Uruchamia konstruktora klasy bazowej
//  obs - pozycja obserwatora,
//  eszer, ewys - rozmiary pikselowe pola obrazowego,
//  odl_ekr - odlego pola obrazowego [m],
//  szer, wys - rozmiar pola obrazowego [m].
TObraz :: TObraz( TPunkt Aobs, int eszer, int ewys,
            double Aodl_ekr, double szer, double wys) :
            TSkalowanie( 0, 0, eszer, ewys, 0, 0, szer, wys)
{
 obs = Aobs;
 Rxy = sqrt( obs.x * obs.x + obs.y * obs.y);
 R = sqrt( Rxy * Rxy + obs.z * obs.z);
 odl_ekr = Aodl_ekr;
}
//---------------------------------------------------------------------------
// Prywatna f. pomocnicza, konstruujca promien wychodzcy
//  od obserwatora i biegncy przez piksel (i, j) paszczyzny obrazowej.
TPromien TObraz :: daj_promien( int i, int j)
{
 double eh, ev;                 //metryczne wsprzdne piksela (i, j) w paszczynie ekranu
 TPunkt e;                      //metryczne wsprzdne piksela w przestrzeni 3d
 double sf = obs.y / Rxy, cf = obs.x / Rxy;
 double st = Rxy / R, ct = obs.z / R;

 eh = daj_real_x( i);           //funkcje odziedziczone z klasy bazowej
 ev = daj_real_y( j);

 TPunkt z( -ev, eh, R-odl_ekr); //gdy ekran jest w zenicie

 e.x = cf * ct * z.x - sf * z.y + cf * st * z.z;
 e.y = sf * ct * z.x + cf * z.y + sf * st * z.z;
 e.z = -st * z.x + ct * z.z;

 return TPromien( obs, e);
}
//---------------------------------------------------------------------------
// Do testowania.
TPunkt TObraz :: daj_punkt( int i, int j)
{
 double eh, ev;                 //metryczne wsprzdne piksela (i, j) w paszczynie ekranu
 TPunkt e;                      //metryczne wsprzdne piksela w przestrzeni 3d
 double sf = obs.y / Rxy, cf = obs.x / Rxy;
 double st = Rxy / R, ct = obs.z / R;

 eh = daj_real_x( i);           //funkcje odziedziczone z klasy bazowej
 ev = daj_real_y( j);

 TPunkt z( -ev, eh, R-odl_ekr); //gdy ekran jest w zenicie

 e.x = cf * ct * z.x - sf * z.y + cf * st * z.z;
 e.y = sf * ct * z.x + cf * z.y + sf * st * z.z;
 e.z = -st * z.x + ct * z.z;

 return e;
}
//---------------------------------------------------------------------------
//  Gwna funkcja algorytmu
TColor TObraz :: kolor_piksela( int i, int j)
{
 TColor k = clBlack;
 TPromien p = daj_promien( i, j);
 return k;
}
