//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "obraz.h"
#include "3d.h"
#include "fobraz2.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
 jasnosc_proc = TrackBar1 -> Position;
 il_odbic     = TrackBar2 -> Position;
}
//---------------------------------------------------------------------------
//  Zabudowa sceny.
void __fastcall TForm1::FormShow(TObject *Sender)
{
 double d = 20;
 TSwiatlo s( 150, 150, 150);
 TOdbicie o( 0.5, 0.5, 0.5);

 czworokat( TPunkt( 0, 0, -1), TPunkt( 0, d, -1),
            TPunkt( d, d, -1), TPunkt( d, 0, -1),
            TSwiatlo( 150, 150, 150), o);
 czworokat( TPunkt( 0, -1, 0), TPunkt( 0, -1, d),
            TPunkt( d, -1, d), TPunkt( d, -1, 0),
            TSwiatlo( 130, 130, 130), o);
 czworokat( TPunkt( -1, 0, 0), TPunkt( -1, 0, d),
            TPunkt( -1, d, d), TPunkt( -1, d, 0),
            TSwiatlo( 100, 100, 100), o);
}
//---------------------------------------------------------------------------
//  Funkcja pomocnicza - wykrrelenie kwadratu jako 2 trjktw
void TForm1 :: czworokat( TPunkt p1, TPunkt p2, TPunkt p3, TPunkt p4,
                        TSwiatlo s, TOdbicie o)
{
 scena.dodaj_trojkat( TTrojkat( p1, p2, p3, s, o));
 scena.dodaj_trojkat( TTrojkat( p1, p3, p4, s, o));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 jasnosc_proc = TrackBar1 -> Position;
 il_odbic     = TrackBar2 -> Position;
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
//  Grafika zoptymalizowana - odwieanie nieaktualneej czci obrazu.
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 int i, j;
 TPunkt oko( 40, 20, 30);
 TObraz obraz( oko,                 //pozycja oka
               PaintBox1->Width, PaintBox1->Height,//pikselowe pole obrazu
               0.5,                 //odlego oka od pola obrazu
               0.5, 0.5,            //metryczne pole obrazu
               &scena,              //zabudowana obiektami
               il_odbic);           //gboko rekurencji

 for( i = PaintBox1->Canvas->ClipRect.Left; i < PaintBox1->Canvas->ClipRect.Right; i ++)      //obraz
 {
    for( j = PaintBox1->Canvas->ClipRect.Top; j < PaintBox1->Canvas->ClipRect.Bottom; j ++)
    {
        PaintBox1 -> Canvas -> Pixels[i][j] = obraz.kolor_piksela( i, j, jasnosc_proc);
    }
 }
}
//---------------------------------------------------------------------------

