//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "fobraz.h"
#include "relatyw3d.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
// Konstruktor
__fastcall TForm1::TForm1(TComponent* Owner): TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
 fb = new Graphics::TBitmap();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
 OpenDialog1 -> FileName = "test.bmp";
 odczytaj_parametry();
 odczytaj_plik();
}
//---------------------------------------------------------------------------
// Wykrelenie prostokta ciany
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 TRelatyw3d rel( obserwator,
    0, 0, PaintBox1 -> Width, PaintBox1 -> Height,  //okno ekranowe
    v,                      //prdko ruchu
    PaintBox1 -> Canvas,    //aparat graficzny
    ogniskowa);             //odlego oka od ekranu


 if( CheckBox1 -> Checked)  //pokazywa ukad odniesienia?
 {
    TPunkt p0( 0, 0, 0), px( 2, 0, 0), py( 0, 2, 0), pz( 0, 0, 2);

    PaintBox1 -> Canvas -> Pen -> Color = clRed;
    rel.linia_relatyw( p0, px, 5);  //X

    PaintBox1 -> Canvas -> Pen -> Color = clGreen;
    rel.linia_relatyw( p0, py, 5);  //Y

    PaintBox1 -> Canvas -> Pen -> Color = clBlue;
    rel.linia_relatyw( p0, pz, 5);  //Z
 }

 if( RadioGroup1 -> ItemIndex == 0)//kostka
 {
    int il_podzial = 5;
    TPunkt p1( 1, 1, -1), p2( -1, 1, -1), p3( -1, -1, -1), p4( 1, -1, -1),
           p5( 1, 1, 1),  p6( -1, 1, 1),  p7( -1, -1, 1),  p8( 1, -1, 1);

    PaintBox1 -> Canvas -> Brush -> Style = bsClear;    //przezroczyste "druty"

    PaintBox1 -> Canvas -> Pen -> Color = clGray;
    rel.czworokat_relatyw( p1, p2, p3, p4, il_podzial); //z -
    rel.czworokat_relatyw( p6, p7, p3, p2, il_podzial); //x -
    rel.czworokat_relatyw( p7, p8, p4, p3, il_podzial); //y -

    PaintBox1 -> Canvas -> Pen -> Color = clBlack;
    rel.czworokat_relatyw( p5, p6, p7, p8, il_podzial); //z +
    rel.czworokat_relatyw( p5, p6, p2, p1, il_podzial); //y +
    rel.czworokat_relatyw( p8, p5, p1, p4, il_podzial); //x +
 }
 else                              //obrazek
 {
    TPunkt p1( 0, -1, 1), p2( 0, 1, 1), p3( 0, 1, -1), p4( 0, -1, -1);

    Canvas -> Brush -> Style = bsSolid;
    rel.czworokat_relatyw( p1, p2, p3, p4, fil_podzial, kolor);
 }
 wyswietl_info();
}
//---------------------------------------------------------------------------
//  Funkcja wywoywana przed wykreleniem kadego fragmentu czworokata
//  Tutaj kolor jest pobierany z bitmapy
void TForm1 :: kolor( TCanvas *cnv, int i, int j)
{
 TColor k = fb -> Canvas -> Pixels[ j][ i];
 cnv -> Pen -> Color = k;
 cnv -> Brush -> Color = k;
}
//---------------------------------------------------------------------------
//  Odczytaj obraz
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 if( OpenDialog1 -> Execute())
 {
    if( odczytaj_plik())
        PaintBox1 -> Refresh();
 }
}
//---------------------------------------------------------------------------
// Odczytaj parametry
void TForm1 :: odczytaj_parametry( void)
{
 try
 {
    v = (double)TrackBar1 -> Position * 1000.;
    obserwator.x = (double)TrackBar2 -> Position / 10.;
    obserwator.y = (double)TrackBar3 -> Position / 10.;
    obserwator.z = (double)TrackBar4 -> Position / 10.;
    ogniskowa = (double)TrackBar5 -> Position / 1000.;
 }
 catch(...)
 {
 }
 wyswietl_info();               //nowy napis
}
//---------------------------------------------------------------------------
// Odczytaj plik z obrazem
bool TForm1 :: odczytaj_plik( void)
{
 try
 {
    int maxx, maxy;
    fb -> LoadFromFile( OpenDialog1 -> FileName);
    maxx = fb -> Width;
    maxy = fb -> Height;
    fil_podzial = maxx > maxy ? maxx : maxy;
    return true;
 }
 catch(...)
 {
    fil_podzial = 0;
 }
 return false;
}
//---------------------------------------------------------------------------
//  Odczytanie parametrw i odrysowanie obiektu, o ile jest to kostka
//  Automatyczne odwieanie obrazka byoby zbyt "upierdliwe" ...
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 wyswietl_info( true);                  //skasuj dotychczasowy napis
 odczytaj_parametry();
 if( RadioGroup1 -> ItemIndex == 0)     //gdy nie obraz ...
    PaintBox1 -> Refresh();             //... to od razu odrysuj
}
//---------------------------------------------------------------------------
// Odrysowanie obrazu (dugotrwae)
void __fastcall TForm1::Button2Click(TObject *Sender)
{
 odczytaj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
// Info o aktualnej prdkoci i pooeniu obserwatora.
//  Gdy kasowanie == true, usuwanie dotychczasowego napisu.
void TForm1 :: wyswietl_info( bool kasowanie/* = NULL*/)
{
 PaintBox1 -> Canvas -> Brush -> Color = Form1 -> Color;

 if( kasowanie)
    PaintBox1 -> Canvas -> Font -> Color = Form1 -> Color;
 else
    PaintBox1 -> Canvas -> Font -> Color = clBlue;

 PaintBox1 -> Canvas -> TextOut( 10, 5, AnsiString ("v = ") +
        AnsiString( v) + " m/s");
 PaintBox1 -> Canvas -> TextOut( 10, 17, AnsiString ("(X,Y,Z) = (") +
        AnsiString( obserwator.x) + " : " +
        AnsiString( obserwator.y) + " : " +
        AnsiString( obserwator.z) + ") m");
 PaintBox1 -> Canvas -> TextOut( 10, 29, AnsiString ("Obiektyw f = ") +
        AnsiString( ogniskowa * 1000.) + " mm");
}
//---------------------------------------------------------------------------
// Zmiana obserwowanego obiektu
void __fastcall TForm1::RadioGroup1Click(TObject *Sender)
{
 Button1 -> Enabled = (RadioGroup1 -> ItemIndex == 1);
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
// Koniec
void __fastcall TForm1::Button3Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------

